﻿import { Component, Inject, OnInit, NgZone, PLATFORM_ID } from '@angular/core';
import { isPlatformBrowser } from '@angular/common';
import { HttpClient } from "@angular/common/http";
import { Router } from "@angular/router";
import { AuthService } from '../../services/auth.service';

// Zadeklaruj te zmienne,
// aby kompilator TS wiedział, że istnieją
declare var window: any;
declare var FB: any;

@Component({
   selector: "login-facebook",
   templateUrl: "./login.facebook.component.html"
})

export class LoginFacebookComponent implements OnInit {

   constructor(
      private http: HttpClient,
      private router: Router,
      private authService: AuthService,
      // Wstrzyknij lokalną strefę
      private zone: NgZone,
      @Inject(PLATFORM_ID) private platformId: any,
      @Inject('BASE_URL') private baseUrl: string) {
   }

   ngOnInit() {
      if (!isPlatformBrowser(this.platformId)) {
         return;
      }

      if (typeof (FB) === 'undefined') {

         // Jeśli obiekt FB jest niezdefiniowany,
         // oznacza to, że odwiedzamy stronę po razi pierwszy,
         // więc musimy zainicjalizować Facebook SDK

         window.fbAsyncInit = () =>
            // Upewnij się, że jest to robione w strefie lokalnej
            // albo Angular nie będzie w stanie odnaleźć referencji lokalnej
            this.zone.run(() => {
               FB.init({
                  appId: '165599590771912',
                  xfbml: true,
                  version: 'v2.12'
               });
               FB.AppEvents.logPageView();

               // Ten kod wykona się tuż po zakończeniu uwierzytelniania
               // za pomocą Facebook SDK
               FB.Event.subscribe('auth.statusChange', (
                  (result: any) => {
                     console.log("Zmiana stanu wierzytelniania FB");
                     console.log(result);
                     if (result.status === 'connected') {
                        // Logowanie udane
                        console.log('Połączono z Facebookiem');
                        this.onConnect(result.authResponse.accessToken);
                     }
                  })
               );
            });

         // Wczytaj bibliotekę SDK w wersji JS (tylko raz)
         (function (d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) { return; }
            js = d.createElement(s); js.id = id;
            (<any>js).src = "//connect.facebook.net/pl_PL/sdk.js";
            fjs.parentNode!.insertBefore(js, fjs);
         }(document, 'script', 'facebook-jssdk'));

      }
      else {

         // Ponownie przetwórz przycisk logowania
         window.FB.XFBML.parse();

         // Jeśli użytkownik jest połączony, wyloguj go
         FB.getLoginStatus(function (response: any) {
            if (response.status === 'connected') {
               FB.logout(function (res: any) {
                  // Nic nie rób
               });
            }
         });
      }
   }

   // Ta metoda zostanie wykonana po zakończeniu
   // komunikacji uwierzytelniającej przez FB SDK,
   // aby utworzyć lub zalogować lokalnego użytkownika
   onConnect(accessToken: string) {
      // Wywołaj TokenController i zarejestruj lub zaloguj użytkownika
      var url = this.baseUrl + "api/token/facebook";
      var data = {
         access_token: accessToken,
         client_id: this.authService.clientId
      };
      this.http.post<TokenResponse>(
         url, data)
         .subscribe(res => {
            if (res) {
               console.log('Logowanie udane');
               console.log(res);
               // Zapamiętaj dane logowania
               this.authService.setAuth(res);

               // Przekieruj na stronę główną
               this.router.navigate(["home"]);
            }
            else {
               console.log("Błąd uwierzytelniania");
            }
         }, error => console.log(error));
   }
}
