.386
.model	flat, stdcall
option	casemap :none

include		bones.inc

.code
start:
	invoke	GetModuleHandle, NULL
	mov	hInstance, eax
	invoke	InitCommonControls
	invoke  LoadLibrary, addr RichEditDLL
	mov     hRichEditDLL, eax
	invoke	DialogBoxParam, hInstance, IDD_MAIN, 0, offset DlgProc, 0
	invoke  FreeLibrary, hRichEditDLL
	invoke	ExitProcess, eax
	
BgTxtColorProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
local chclr: CHOOSECOLOR
local cfm: CHARFORMAT
	mov eax, uMsg
	.if	eax == WM_INITDIALOG
		
	.elseif eax == WM_COMMAND
		mov	eax,wParam
		.if	eax == 1006 ; zmie kolor tekstu
			invoke RtlZeroMemory, addr chclr, sizeof chclr
			mov    chclr.lStructSize, sizeof chclr
			push   hWin
			pop    chclr.hwndOwner
			push   hInstance
			pop    chclr.hInstance
			push   TextColor
			pop    chclr.rgbResult
			mov    chclr.lpCustColors, offset CustomColors
			mov    chclr.Flags, CC_ANYCOLOR or CC_RGBINIT
			invoke ChooseColor, addr chclr
			.if eax != 0
				push   chclr.rgbResult
				pop    TextColor
				invoke RtlZeroMemory, addr cfm, sizeof cfm
				mov    cfm.cbSize, sizeof cfm
				mov    cfm.dwMask, CFM_COLOR
				push   TextColor
				pop    cfm.crTextColor
				invoke SendMessage, hRichEdit, EM_SETCHARFORMAT, SCF_ALL, addr cfm
			.endif
		.elseif eax == 1007 ; zmie kolor ta
			invoke RtlZeroMemory, addr chclr, sizeof chclr
			mov    chclr.lStructSize, sizeof chclr
			push   hWin
			pop    chclr.hwndOwner
			push   hInstance
			pop    chclr.hInstance
			push   BackgroundColor
			pop    chclr.rgbResult
			mov    chclr.lpCustColors, offset CustomColors
			mov    chclr.Flags, CC_ANYCOLOR or CC_RGBINIT
			invoke ChooseColor, addr chclr
			.if eax != 0
				push   chclr.rgbResult
				pop    BackgroundColor
				invoke SendMessage, hRichEdit, EM_SETBKGNDCOLOR, 0, BackgroundColor
			.endif
		.endif
	.elseif	eax == WM_CLOSE
		invoke	EndDialog, hWin, 0
	.else
		invoke DefWindowProc, hWin, uMsg, wParam, lParam
	.endif
	xor eax, eax
	ret
BgTxtColorProc endp
	
FindProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	mov eax, uMsg
	.if	eax == WM_INITDIALOG
		invoke CheckRadioButton, hWin, 1015, 1016, 1016
		invoke SendDlgItemMessage, hWin, 1011, WM_SETTEXT, 0, addr FindBuffer
	.elseif eax == WM_COMMAND
		mov eax, wParam
		.if eax == 1017
			invoke SendMessage, hRichEdit, EM_EXGETSEL, 0, addr findtext.chrg
			invoke GetDlgItemText, hWin, 1011, addr FindBuffer, sizeof FindBuffer
			.if eax!=0
				invoke IsDlgButtonChecked, hWin, 1016
				.if eax == BST_CHECKED
					or   uFlags, FR_DOWN
					mov eax, findtext.chrg.cpMin
					.if eax != findtext.chrg.cpMax
						push findtext.chrg.cpMax
						pop  findtext.chrg.cpMin
					.endif
					mov findtext.chrg.cpMax, -1
				.else
					mov findtext.chrg.cpMax, 0
				.endif
				invoke IsDlgButtonChecked, hWin, 1012
				.if eax == BST_CHECKED
					or uFlags, FR_MATCHCASE
				.endif
				invoke IsDlgButtonChecked, hWin, 1013
				.if eax == BST_CHECKED
					or uFlags, FR_WHOLEWORD
				.endif
				mov    findtext.lpstrText, offset FindBuffer
				invoke SendMessage, hRichEdit, EM_FINDTEXTEX, uFlags, addr findtext
				.if eax != -1
					invoke SendMessage, hRichEdit, EM_EXSETSEL, 0, addr findtext.chrgText
				.endif
			.endif
			invoke SendMessage, hWin, WM_CLOSE, 0, 0
		.elseif eax == 1018
			invoke SendMessage, hWin, WM_CLOSE, 0, 0
		.endif
	.elseif	eax == WM_CLOSE
		invoke	EndDialog, hWin, 0
	.else
		invoke DefWindowProc, hWin, uMsg, wParam, lParam
	.endif
	xor eax, eax
	ret
FindProc endp
	
ReplaceProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
local settext: SETTEXTEX
	mov eax, uMsg
	.if	eax == WM_INITDIALOG
		invoke SetDlgItemText, hWin, 1020, addr FindBuffer
		invoke SetDlgItemText, hWin, 1022, addr ReplaceBuffer
	.elseif eax == WM_COMMAND
		mov eax, wParam
		.if eax == 1023
			invoke GetDlgItemText, hWin, 1020, addr FindBuffer, sizeof FindBuffer
			invoke GetDlgItemText, hWin, 1022, addr ReplaceBuffer, sizeof ReplaceBuffer
			mov    findtext.chrg.cpMin, 0
			mov    findtext.chrg.cpMax, -1
			mov    findtext.lpstrText, offset FindBuffer
			mov    settext.flags, ST_SELECTION
			mov    settext.codepage, CP_ACP
			.while TRUE
				invoke SendMessage, hRichEdit, EM_FINDTEXTEX, FR_DOWN, addr findtext
			.break .if eax == -1
				invoke SendMessage, hRichEdit, EM_EXSETSEL, 0, addr findtext.chrgText
				invoke SendMessage, hRichEdit, EM_SETTEXTEX, addr settext, addr ReplaceBuffer
			.endw
		.endif
	.elseif	eax == WM_CLOSE
		invoke	EndDialog, hWin, 0
	.else
		invoke DefWindowProc, hWin, uMsg, wParam, lParam
	.endif
	xor eax, eax
	ret
ReplaceProc endp
	
GotoProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
local LineNum: DWORD
	mov eax, uMsg
	.if	eax == WM_INITDIALOG
		
	.elseif eax == WM_COMMAND
		mov	eax,wParam
		.if eax == 1009
			invoke GetDlgItemInt, hWin, 1008, NULL, FALSE
			mov    LineNum, eax
			invoke SendMessage, hRichEdit, EM_GETLINECOUNT, 0, 0
			.if eax > LineNum
				invoke SendMessage, hRichEdit, EM_LINEINDEX, LineNum, 0
				invoke SendMessage, hRichEdit, EM_SETSEL, eax, eax
				invoke SetFocus, hRichEdit
			.endif
			invoke SendMessage, hWin, WM_CLOSE, 0, 0
		.endif
	.elseif	eax == WM_CLOSE
		invoke	EndDialog, hWin, 0
	.else
		invoke DefWindowProc, hWin, uMsg, wParam, lParam
	.endif
	xor eax, eax
	ret
GotoProc endp

StreamInProc proc hFile:      DWORD,
                  pBuffer:    DWORD,
                  NumBytes:   DWORD,
                  pBytesRead: DWORD

    invoke ReadFile, hFile, pBuffer, NumBytes, pBytesRead, 0
    xor eax, 1
    ret

StreamInProc ENDP

StreamOutProc proc hFile:         DWORD,
                   pBuffer:       DWORD,
                   NumBytes:      DWORD,
                   pBytesWritten: DWORD

    invoke WriteFile, hFile, pBuffer, NumBytes, pBytesWritten, 0
    xor eax, 1
    ret

StreamOutProc endp

DlgProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
local chrg: CHARRANGE
local ofn: OPENFILENAME
local editstream:  EDITSTREAM
local hFile:       dword
	mov	eax,uMsg
	
	.if	eax == WM_INITDIALOG
		invoke	LoadIcon,hInstance,200
		invoke	SendMessage, hWin, WM_SETICON, 1, eax
		invoke GetDlgItem, hWin, 1001
		mov hRichEdit, eax
		invoke SendMessage, hRichEdit, EM_AUTOURLDETECT, TRUE, 0
	.elseif eax == WM_COMMAND
		mov	eax,wParam
		.if	eax == IDM_NEW
			.if FileSaved == FALSE
				invoke MessageBox, hWin, addr szWannaSave, addr szCaption, MB_YESNO+MB_ICONQUESTION
				.if eax == IDYES
					invoke SendMessage, hWin, WM_COMMAND, IDM_SAVE, 0
				.elseif eax == IDNO
					mov    chrg.cpMin, 0
					mov    chrg.cpMax, -1
					invoke SendMessage, hRichEdit, EM_EXSETSEL, 0, addr chrg
					invoke SendMessage, hRichEdit, EM_REPLACESEL, TRUE, 0
				.endif
			.endif
		.elseif eax == IDM_OPEN
			invoke RtlZeroMemory, addr ofn, sizeof ofn
			mov    ofn.lStructSize, sizeof ofn
			push   hWin
			pop    ofn.hwndOwner
			push   hInstance
			pop    ofn.hInstance
			mov    ofn.lpstrFilter, offset FilterString
			mov    ofn.lpstrFile, offset szFileName
			mov    byte ptr [szFileName], 0
			mov    ofn.nMaxFile, sizeof szFileName
			mov    ofn.Flags, OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or \
			                      OFN_PATHMUSTEXIST
			invoke GetOpenFileName, addr ofn
			.if eax!=0
				invoke CreateFile, addr szFileName, GENERIC_READ,
				                       FILE_SHARE_READ, NULL,
				                       OPEN_EXISTING,
				                       FILE_ATTRIBUTE_NORMAL, 0
				.if eax != INVALID_HANDLE_VALUE
					mov    hFile, eax
					mov    editstream.dwCookie, eax
					mov    editstream.pfnCallback, offset StreamInProc
					invoke SendMessage, hRichEdit, EM_STREAMIN,
					                     SF_TEXT, addr editstream
					invoke SendMessage, hRichEdit, EM_SETMODIFY,
					                        FALSE, 0
					invoke CloseHandle, hFile
					mov    FileOpened, TRUE
				.endif
			.endif
		.elseif eax == IDM_SAVE
			.if FileSaved == TRUE
				invoke CreateFile, addr szFileName2, GENERIC_WRITE,
				                       FILE_SHARE_READ, NULL, CREATE_ALWAYS,
				                       FILE_ATTRIBUTE_NORMAL, 0
				.if eax != INVALID_HANDLE_VALUE
					mov    hFile, eax
					mov    editstream.dwCookie, eax
					mov    editstream.pfnCallback, offset StreamOutProc
					invoke SendMessage, hRichEdit, EM_STREAMOUT,
					                        SF_TEXT, addr editstream
					invoke SendMessage, hRichEdit, EM_SETMODIFY, FALSE, 0
					invoke CloseHandle, hFile
				.endif
			.else
				invoke SendMessage, hWin, WM_COMMAND, IDM_SAVEAS, 0
			.endif
		.elseif eax == IDM_SAVEAS
			invoke RtlZeroMemory, addr ofn, sizeof ofn
			mov    ofn.lStructSize, sizeof ofn
			push   hWin
			pop    ofn.hwndOwner
			push   hInstance
			pop    ofn.hInstance
			mov    ofn.lpstrFilter, offset FilterString
			mov    ofn.lpstrFile, offset szFileName2
			mov    byte ptr [szFileName2], 0
			mov    ofn.nMaxFile, sizeof szFileName2
			mov    ofn.Flags, OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or \
			                     OFN_PATHMUSTEXIST
			invoke GetSaveFileName, addr ofn
			.if eax != 0
				invoke CreateFile, addr szFileName2,
				                       GENERIC_WRITE, FILE_SHARE_READ,
				                       NULL, CREATE_ALWAYS,
				                      FILE_ATTRIBUTE_NORMAL, 0
				.if eax != INVALID_HANDLE_VALUE
					mov    hFile, eax
					mov    editstream.dwCookie, eax
					mov    editstream.pfnCallback, offset StreamOutProc
					invoke SendMessage, hRichEdit, EM_STREAMOUT,
					                        SF_TEXT, addr editstream
					invoke SendMessage, hRichEdit, EM_SETMODIFY, FALSE, 0
					invoke CloseHandle, hFile
					mov FileSaved, TRUE
				.endif
			.endif
		.elseif eax == IDM_EXIT
			invoke SendMessage, hWin, WM_CLOSE, 0, 0
		.elseif eax == IDM_UNDO
			invoke SendMessage, hRichEdit, EM_UNDO, 0, 0
		.elseif eax == IDM_REDO
			invoke SendMessage, hRichEdit, EM_REDO, 0, 0
		.elseif eax == IDM_CUT
			invoke SendMessage, hRichEdit, WM_CUT, 0, 0
		.elseif eax == IDM_COPY
			invoke SendMessage, hRichEdit, WM_COPY, 0, 0
		.elseif eax == IDM_PASTE
			invoke SendMessage, hRichEdit, WM_PASTE, 0, 0
		.elseif eax == IDM_DELETE
			invoke SendMessage, hRichEdit, EM_REPLACESEL, TRUE, 0
		.elseif eax == IDM_FIND
			invoke DialogBoxParam, hInstance, IDD_FIND, 0, addr FindProc, 0
		.elseif eax == IDM_FINDNEXT
			invoke lstrlen, addr FindBuffer
			.if eax != 0
				invoke SendMessage, hRichEdit, EM_EXGETSEL, 0,
				                        addr findtext.chrg
				mov eax, findtext.chrg.cpMin
				.if eax != findtext.chrg.cpMax
					push findtext.chrg.cpMax
					pop  findtext.chrg.cpMin
				.endif
				mov    findtext.chrg.cpMax, -1
				mov    findtext.lpstrText, offset FindBuffer
				invoke SendMessage, hRichEdit, EM_FINDTEXTEX,
				                       FR_DOWN, addr findtext
				.if eax!=-1
					invoke SendMessage, hRichEdit, EM_EXSETSEL,
					                        0, addr findtext.chrgText
				.endif
			.endif
		.elseif eax == IDM_REPLACE
			invoke DialogBoxParam, hInstance, IDD_REPLACE, 0, addr ReplaceProc, 0
		.elseif eax == IDM_GOTO
			invoke DialogBoxParam, hInstance, IDD_GOTO, 0, addr GotoProc, 0
		.elseif eax == IDM_SELECTALL
			mov    chrg.cpMin, 0
			mov    chrg.cpMax, -1
			invoke SendMessage, hRichEdit, EM_EXSETSEL, 0, addr chrg
		.elseif eax == IDM_BGTXTCOLOR
			invoke DialogBoxParam, hInstance, IDD_BGTXTCOLOR, 0, addr BgTxtColorProc, 0
		.elseif eax == IDM_ABOUT
			invoke MessageBox, hWin, addr szAbout, addr szCaption, MB_OK+MB_ICONINFORMATION
		.endif
	.elseif eax == WM_INITMENUPOPUP
		mov eax, lParam
		.if ax == 1
			; czy mona wklei
			invoke SendMessage, hRichEdit, EM_CANPASTE, CF_TEXT, 0
			.if eax == 0    ; nie ma tekstu w schowku
				invoke EnableMenuItem, wParam, IDM_PASTE, MF_GRAYED
			.else
				invoke EnableMenuItem, wParam, IDM_PASTE, MF_ENABLED
			.endif
			; czy mona cofn
			invoke SendMessage, hRichEdit, EM_CANUNDO, 0, 0
			.if eax==0
				invoke EnableMenuItem, wParam, IDM_UNDO, MF_GRAYED
			.else
				invoke EnableMenuItem, wParam, IDM_UNDO, MF_ENABLED
			.endif
			; czy mona powtrzy
			invoke SendMessage, hRichEdit, EM_CANREDO, 0, 0
			.if eax==0
				invoke EnableMenuItem, wParam, IDM_REDO, MF_GRAYED
			.else
				invoke EnableMenuItem, wParam, IDM_REDO, MF_ENABLED
			.endif
			; czy jest wybrany jaki tekst
			invoke SendMessage, hRichEdit, EM_EXGETSEL, 0, addr chrg
			mov eax, chrg.cpMin
			.if eax == chrg.cpMax  ; brak biecego wyboru tekstu
				invoke EnableMenuItem, wParam, IDM_COPY, MF_GRAYED
				invoke EnableMenuItem, wParam, IDM_CUT, MF_GRAYED
				invoke EnableMenuItem, wParam, IDM_DELETE, MF_GRAYED
			.else
				invoke EnableMenuItem, wParam, IDM_COPY, MF_ENABLED
				invoke EnableMenuItem, wParam, IDM_CUT, MF_ENABLED
				invoke EnableMenuItem, wParam, IDM_DELETE, MF_ENABLED
			.endif
		.endif
	.elseif eax == WM_SIZE
		movzx  eax, word ptr lParam
		movzx  edx, word ptr lParam + 2
		invoke MoveWindow, hRichEdit, 0, 0, eax, edx, TRUE
	.elseif	eax == WM_CLOSE
		.if FileSaved == FALSE
			invoke MessageBox, hWin, addr szWannaSave, addr szCaption, MB_YESNO+MB_ICONQUESTION
			.if eax == IDYES
				invoke SendMessage, hWin, WM_COMMAND, IDM_SAVE, 0
			.elseif eax == IDNO
				invoke	EndDialog, hWin, 0
			.endif
		.endif
	.endif
	
	xor	eax,eax
	ret
DlgProc endp

end start