/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;

public class ProgressBarCompat
extends View {
    private static final int MAX_LEVEL = 10000;
    private static final int ANIMATION_RESOLUTION = 200;
    private static final int[] android_R_styleable_ProgressBar = new int[]{16843062, 16843063, 16843064, 16843065, 16843066, 16843067, 16843068, 16843069, 16843070, 16843071, 0x101011F, 0x1010140, 0x1010120, 0x1010141};
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mProgress;
    private int mSecondaryProgress;
    private int mMax;
    private int mBehavior;
    private int mDuration;
    private boolean mIndeterminate;
    private boolean mOnlyIndeterminate;
    private Transformation mTransformation;
    private AlphaAnimation mAnimation;
    private Drawable mIndeterminateDrawable;
    private Drawable mProgressDrawable;
    private Drawable mCurrentDrawable;
    Bitmap mSampleTile;
    private boolean mNoInvalidate;
    private Interpolator mInterpolator;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    private long mUiThreadId = Thread.currentThread().getId();
    private boolean mShouldStartAnimationDrawable;
    private long mLastDrawTime;
    private boolean mInDrawing;

    public ProgressBarCompat(Context context, AttributeSet attrs, int defStyle, int styleRes) {
        super(context, attrs, defStyle);
        this.initProgressBar();
        TypedArray a = context.obtainStyledAttributes(attrs, android_R_styleable_ProgressBar, defStyle, styleRes);
        this.mNoInvalidate = true;
        this.setMax(a.getInt(0, this.mMax));
        this.setProgress(a.getInt(1, this.mProgress));
        this.setSecondaryProgress(a.getInt(2, this.mSecondaryProgress));
        boolean indeterminate = a.getBoolean(3, this.mIndeterminate);
        this.mOnlyIndeterminate = a.getBoolean(4, this.mOnlyIndeterminate);
        Drawable drawable2 = a.getDrawable(5);
        if (drawable2 != null) {
            drawable2 = this.tileifyIndeterminate(drawable2);
            this.setIndeterminateDrawable(drawable2);
        }
        if ((drawable2 = a.getDrawable(6)) != null) {
            drawable2 = this.tileify(drawable2, false);
            this.setProgressDrawable(drawable2);
        }
        this.mDuration = a.getInt(7, this.mDuration);
        this.mBehavior = a.getInt(8, this.mBehavior);
        this.mMinWidth = a.getDimensionPixelSize(9, this.mMinWidth);
        this.mMaxWidth = a.getDimensionPixelSize(10, this.mMaxWidth);
        this.mMinHeight = a.getDimensionPixelSize(11, this.mMinHeight);
        this.mMaxHeight = a.getDimensionPixelSize(12, this.mMaxHeight);
        int resID = a.getResourceId(13, 17432587);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        a.recycle();
        this.mNoInvalidate = false;
        this.setIndeterminate(this.mOnlyIndeterminate || indeterminate);
    }

    private Drawable tileify(Drawable drawable2, boolean clip) {
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable background = (LayerDrawable)drawable2;
            int N = background.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = background.getId(i);
                outDrawables[i] = this.tileify(background.getDrawable(i), id2 == 16908301 || id2 == 16908303);
            }
            LayerDrawable newBg = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                newBg.setId(i, background.getId(i));
            }
            return newBg;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap tileBitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = tileBitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader((Shader)bitmapShader);
            return clip ? new ClipDrawable((Drawable)shapeDrawable, 3, 1) : shapeDrawable;
        }
        return drawable2;
    }

    Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    public synchronized boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        if (!(this.mOnlyIndeterminate && this.mIndeterminate || indeterminate == this.mIndeterminate)) {
            this.mIndeterminate = indeterminate;
            if (indeterminate) {
                this.mCurrentDrawable = this.mIndeterminateDrawable;
                this.startAnimation();
            } else {
                this.mCurrentDrawable = this.mProgressDrawable;
                this.stopAnimation();
            }
        }
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public void setIndeterminateDrawable(Drawable d) {
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
        }
        this.mIndeterminateDrawable = d;
        if (this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public void setProgressDrawable(Drawable d) {
        boolean needUpdate;
        if (this.mProgressDrawable != null && d != this.mProgressDrawable) {
            this.mProgressDrawable.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
            int drawableHeight = d.getMinimumHeight();
            if (this.mMaxHeight < drawableHeight) {
                this.mMaxHeight = drawableHeight;
                this.requestLayout();
            }
        }
        this.mProgressDrawable = d;
        if (!this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
        if (needUpdate) {
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(16908301, this.mProgress, false, false);
            this.doRefreshProgress(16908303, this.mSecondaryProgress, false, false);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mProgressDrawable || who == this.mIndeterminateDrawable || super.verifyDrawable(who);
    }

    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    private synchronized void doRefreshProgress(int id2, int progress, boolean fromUser, boolean callBackToApp) {
        float scale = this.mMax > 0 ? (float)progress / (float)this.mMax : 0.0f;
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            Drawable progressDrawable = null;
            if (d instanceof LayerDrawable) {
                progressDrawable = ((LayerDrawable)d).findDrawableByLayerId(id2);
            }
            int level = (int)(scale * 10000.0f);
            (progressDrawable != null ? progressDrawable : d).setLevel(level);
        } else {
            this.invalidate();
        }
    }

    private synchronized void refreshProgress(int id2, int progress, boolean fromUser) {
        if (this.mUiThreadId == Thread.currentThread().getId()) {
            this.doRefreshProgress(id2, progress, fromUser, true);
        } else {
            RefreshProgressRunnable r;
            if (this.mRefreshProgressRunnable != null) {
                r = this.mRefreshProgressRunnable;
                this.mRefreshProgressRunnable = null;
                r.setup(id2, progress, fromUser);
            } else {
                r = new RefreshProgressRunnable(id2, progress, fromUser);
            }
            this.post(r);
        }
    }

    public synchronized void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    synchronized void setProgress(int progress, boolean fromUser) {
        if (this.mIndeterminate) {
            return;
        }
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.mMax) {
            progress = this.mMax;
        }
        if (progress != this.mProgress) {
            this.mProgress = progress;
            this.refreshProgress(16908301, this.mProgress, fromUser);
        }
    }

    public synchronized void setSecondaryProgress(int secondaryProgress) {
        if (this.mIndeterminate) {
            return;
        }
        if (secondaryProgress < 0) {
            secondaryProgress = 0;
        }
        if (secondaryProgress > this.mMax) {
            secondaryProgress = this.mMax;
        }
        if (secondaryProgress != this.mSecondaryProgress) {
            this.mSecondaryProgress = secondaryProgress;
            this.refreshProgress(16908303, this.mSecondaryProgress, false);
        }
    }

    public synchronized int getProgress() {
        return this.mIndeterminate ? 0 : this.mProgress;
    }

    public synchronized int getSecondaryProgress() {
        return this.mIndeterminate ? 0 : this.mSecondaryProgress;
    }

    public synchronized int getMax() {
        return this.mMax;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mProgress > max) {
                this.mProgress = max;
            }
            this.refreshProgress(16908301, this.mProgress, false);
        }
    }

    public final synchronized void incrementProgressBy(int diff) {
        this.setProgress(this.mProgress + diff);
    }

    public final synchronized void incrementSecondaryProgressBy(int diff) {
        this.setSecondaryProgress(this.mSecondaryProgress + diff);
    }

    void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mAnimation = null;
        } else {
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            this.mTransformation = new Transformation();
            this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration((long)this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
        }
        this.postInvalidate();
    }

    void stopAnimation() {
        this.mAnimation = null;
        this.mTransformation = null;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)this.mIndeterminateDrawable).stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    public void setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resID));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (this.mIndeterminate) {
                if (v == 8 || v == 4) {
                    this.stopAnimation();
                } else {
                    this.startAnimation();
                }
            }
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onVisibilityChanged(changedView, visibility);
        }
        if (this.mIndeterminate) {
            if (visibility == 8 || visibility == 4) {
                this.stopAnimation();
            } else {
                this.startAnimation();
            }
        }
    }

    public void invalidateDrawable(Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.getScrollX() + this.getPaddingLeft();
                int scrollY = this.getScrollY() + this.getPaddingTop();
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawableBounds(w, h);
    }

    private void updateDrawableBounds(int w, int h) {
        int right = w - this.getPaddingRight() - this.getPaddingLeft();
        int bottom = h - this.getPaddingBottom() - this.getPaddingTop();
        int top = 0;
        int left = 0;
        if (this.mIndeterminateDrawable != null) {
            float boundAspect;
            int intrinsicHeight;
            int intrinsicWidth;
            float intrinsicAspect;
            if (this.mOnlyIndeterminate && !(this.mIndeterminateDrawable instanceof AnimationDrawable) && (intrinsicAspect = (float)(intrinsicWidth = this.mIndeterminateDrawable.getIntrinsicWidth()) / (float)(intrinsicHeight = this.mIndeterminateDrawable.getIntrinsicHeight())) != (boundAspect = (float)w / (float)h)) {
                if (boundAspect > intrinsicAspect) {
                    int width = (int)((float)h * intrinsicAspect);
                    left = (w - width) / 2;
                    right = left + width;
                } else {
                    int height = (int)((float)w * (1.0f / intrinsicAspect));
                    top = (h - height) / 2;
                    bottom = top + height;
                }
            }
            this.mIndeterminateDrawable.setBounds(left, top, right, bottom);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, right, bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            long time = this.getDrawingTime();
            if (this.mAnimation != null) {
                this.mAnimation.getTransformation(time, this.mTransformation);
                float scale = this.mTransformation.getAlpha();
                try {
                    this.mInDrawing = true;
                    d.setLevel((int)(scale * 10000.0f));
                }
                finally {
                    this.mInDrawing = false;
                }
                if (SystemClock.uptimeMillis() - this.mLastDrawTime >= 200L) {
                    this.mLastDrawTime = SystemClock.uptimeMillis();
                    this.postInvalidateDelayed(200L);
                }
            }
            d.draw(canvas);
            canvas.restore();
            if (this.mShouldStartAnimationDrawable && d instanceof Animatable) {
                ((Animatable)d).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.mCurrentDrawable;
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        this.updateDrawableState();
        this.setMeasuredDimension(ProgressBarCompat.resolveSize((int)(dw += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec), ProgressBarCompat.resolveSize((int)(dh += this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    private void updateDrawableState() {
        int[] state = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            this.mProgressDrawable.setState(state);
        }
        if (this.mIndeterminateDrawable != null && this.mIndeterminateDrawable.isStateful()) {
            this.mIndeterminateDrawable.setState(state);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        ss.secondaryProgress = this.mSecondaryProgress;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.progress);
        this.setSecondaryProgress(ss.secondaryProgress);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
        }
        super.onDetachedFromWindow();
    }

    static class SavedState
    extends View.BaseSavedState {
        int progress;
        int secondaryProgress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.secondaryProgress = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.secondaryProgress);
        }
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private int mId;
        private int mProgress;
        private boolean mFromUser;

        RefreshProgressRunnable(int id2, int progress, boolean fromUser) {
            this.mId = id2;
            this.mProgress = progress;
            this.mFromUser = fromUser;
        }

        @Override
        public void run() {
            ProgressBarCompat.this.doRefreshProgress(this.mId, this.mProgress, this.mFromUser, true);
            ProgressBarCompat.this.mRefreshProgressRunnable = this;
        }

        public void setup(int id2, int progress, boolean fromUser) {
            this.mId = id2;
            this.mProgress = progress;
            this.mFromUser = fromUser;
        }
    }
}

