/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompatHoneycomb;
import android.support.v4.graphics.drawable.DrawableCompatKitKat;
import android.support.v4.graphics.drawable.DrawableCompatL;

public class DrawableCompat {
    static final DrawableImpl IMPL;

    public static void jumpToCurrentState(Drawable drawable) {
        IMPL.jumpToCurrentState(drawable);
    }

    public static void setAutoMirrored(Drawable drawable, boolean mirrored) {
        IMPL.setAutoMirrored(drawable, mirrored);
    }

    public static boolean isAutoMirrored(Drawable drawable) {
        return IMPL.isAutoMirrored(drawable);
    }

    public static void setHotspot(Drawable drawable, float x, float y) {
        IMPL.setHotspot(drawable, x, y);
    }

    public static void setHotspotBounds(Drawable drawable, int left, int top, int right, int bottom) {
        IMPL.setHotspotBounds(drawable, left, top, right, bottom);
    }

    public static void setTint(Drawable drawable, int tint) {
        IMPL.setTint(drawable, tint);
    }

    public static void setTintList(Drawable drawable, ColorStateList tint) {
        IMPL.setTintList(drawable, tint);
    }

    public static void setTintMode(Drawable drawable, PorterDuff.Mode tintMode) {
        IMPL.setTintMode(drawable, tintMode);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new LDrawableImpl() : (version >= 19 ? new KitKatDrawableImpl() : (version >= 11 ? new HoneycombDrawableImpl() : new BaseDrawableImpl()));
    }

    static class LDrawableImpl
    extends KitKatDrawableImpl {
        LDrawableImpl() {
        }

        @Override
        public void setHotspot(Drawable drawable, float x, float y) {
            DrawableCompatL.setHotspot((Drawable)drawable, (float)x, (float)y);
        }

        @Override
        public void setHotspotBounds(Drawable drawable, int left, int top, int right, int bottom) {
            DrawableCompatL.setHotspotBounds((Drawable)drawable, (int)left, (int)top, (int)right, (int)bottom);
        }

        @Override
        public void setTint(Drawable drawable, int tint) {
            DrawableCompatL.setTint((Drawable)drawable, (int)tint);
        }

        @Override
        public void setTintList(Drawable drawable, ColorStateList tint) {
            DrawableCompatL.setTintList((Drawable)drawable, (ColorStateList)tint);
        }

        @Override
        public void setTintMode(Drawable drawable, PorterDuff.Mode tintMode) {
            DrawableCompatL.setTintMode((Drawable)drawable, (PorterDuff.Mode)tintMode);
        }
    }

    static class KitKatDrawableImpl
    extends HoneycombDrawableImpl {
        KitKatDrawableImpl() {
        }

        @Override
        public void setAutoMirrored(Drawable drawable, boolean mirrored) {
            DrawableCompatKitKat.setAutoMirrored((Drawable)drawable, (boolean)mirrored);
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable) {
            return DrawableCompatKitKat.isAutoMirrored((Drawable)drawable);
        }
    }

    static class HoneycombDrawableImpl
    extends BaseDrawableImpl {
        HoneycombDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable) {
            DrawableCompatHoneycomb.jumpToCurrentState((Drawable)drawable);
        }
    }

    static class BaseDrawableImpl
    implements DrawableImpl {
        BaseDrawableImpl() {
        }

        @Override
        public void jumpToCurrentState(Drawable drawable) {
        }

        @Override
        public void setAutoMirrored(Drawable drawable, boolean mirrored) {
        }

        @Override
        public boolean isAutoMirrored(Drawable drawable) {
            return false;
        }

        @Override
        public void setHotspot(Drawable drawable, float x, float y) {
        }

        @Override
        public void setHotspotBounds(Drawable drawable, int left, int top, int right, int bottom) {
        }

        @Override
        public void setTint(Drawable drawable, int tint) {
        }

        @Override
        public void setTintList(Drawable drawable, ColorStateList tint) {
        }

        @Override
        public void setTintMode(Drawable drawable, PorterDuff.Mode tintMode) {
        }
    }

    static interface DrawableImpl {
        public void jumpToCurrentState(Drawable var1);

        public void setAutoMirrored(Drawable var1, boolean var2);

        public boolean isAutoMirrored(Drawable var1);

        public void setHotspot(Drawable var1, float var2, float var3);

        public void setHotspotBounds(Drawable var1, int var2, int var3, int var4, int var5);

        public void setTint(Drawable var1, int var2);

        public void setTintList(Drawable var1, ColorStateList var2);

        public void setTintMode(Drawable var1, PorterDuff.Mode var2);
    }
}

