/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.MediaControllerCompatApi21;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;

public final class MediaControllerCompat {
    private final MediaControllerImpl mImpl;

    public MediaControllerCompat(Context context, MediaSessionCompat session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, session) : new MediaControllerImplBase();
    }

    public MediaControllerCompat(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken must not be null");
        }
        this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, sessionToken) : new MediaControllerImplBase();
    }

    public TransportControls getTransportControls() {
        return this.mImpl.getTransportControls();
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        return this.mImpl.dispatchMediaButtonEvent(keyEvent);
    }

    public PlaybackStateCompat getPlaybackState() {
        return this.mImpl.getPlaybackState();
    }

    public MediaMetadataCompat getMetadata() {
        return this.mImpl.getMetadata();
    }

    public int getRatingType() {
        return this.mImpl.getRatingType();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mImpl.getPlaybackInfo();
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    public void registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        this.mImpl.registerCallback(callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.mImpl.unregisterCallback(callback);
    }

    public void sendCommand(String command, Bundle params, ResultReceiver cb) {
        if (TextUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        this.mImpl.sendCommand(command, params, cb);
    }

    public Object getMediaController() {
        return this.mImpl.getMediaController();
    }

    static class TransportControlsApi21
    extends TransportControls {
        private final Object mControlsObj;

        public TransportControlsApi21(Object controlsObj) {
            this.mControlsObj = controlsObj;
        }

        @Override
        public void play() {
            MediaControllerCompatApi21.TransportControls.play((Object)this.mControlsObj);
        }

        @Override
        public void pause() {
            MediaControllerCompatApi21.TransportControls.pause((Object)this.mControlsObj);
        }

        @Override
        public void stop() {
            MediaControllerCompatApi21.TransportControls.stop((Object)this.mControlsObj);
        }

        @Override
        public void seekTo(long pos) {
            MediaControllerCompatApi21.TransportControls.seekTo((Object)this.mControlsObj, (long)pos);
        }

        @Override
        public void fastForward() {
            MediaControllerCompatApi21.TransportControls.fastForward((Object)this.mControlsObj);
        }

        @Override
        public void rewind() {
            MediaControllerCompatApi21.TransportControls.rewind((Object)this.mControlsObj);
        }

        @Override
        public void skipToNext() {
            MediaControllerCompatApi21.TransportControls.skipToNext((Object)this.mControlsObj);
        }

        @Override
        public void skipToPrevious() {
            MediaControllerCompatApi21.TransportControls.skipToPrevious((Object)this.mControlsObj);
        }

        @Override
        public void setRating(RatingCompat rating) {
            MediaControllerCompatApi21.TransportControls.setRating((Object)this.mControlsObj, (Object)(rating != null ? rating.getRating() : null));
        }
    }

    static class MediaControllerImplApi21
    implements MediaControllerImpl {
        private final Object mControllerObj;

        public MediaControllerImplApi21(Context context, MediaSessionCompat session) {
            this.mControllerObj = MediaControllerCompatApi21.fromToken((Context)context, (Object)session.getSessionToken().getToken());
        }

        public MediaControllerImplApi21(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            this.mControllerObj = MediaControllerCompatApi21.fromToken((Context)context, (Object)sessionToken.getToken());
            if (this.mControllerObj == null) {
                throw new RemoteException();
            }
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
            MediaControllerCompatApi21.registerCallback((Object)this.mControllerObj, (Object)callback.mCallbackObj, (Handler)handler);
        }

        @Override
        public void unregisterCallback(Callback callback) {
            MediaControllerCompatApi21.unregisterCallback((Object)this.mControllerObj, (Object)callback.mCallbackObj);
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            return MediaControllerCompatApi21.dispatchMediaButtonEvent((Object)this.mControllerObj, (KeyEvent)event);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls((Object)this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi21(controlsObj) : null;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object stateObj = MediaControllerCompatApi21.getPlaybackState((Object)this.mControllerObj);
            return stateObj != null ? PlaybackStateCompat.fromPlaybackState(stateObj) : null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            Object metadataObj = MediaControllerCompatApi21.getMetadata((Object)this.mControllerObj);
            return metadataObj != null ? MediaMetadataCompat.fromMediaMetadata(metadataObj) : null;
        }

        @Override
        public int getRatingType() {
            return MediaControllerCompatApi21.getRatingType((Object)this.mControllerObj);
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            Object volumeInfoObj = MediaControllerCompatApi21.getPlaybackInfo((Object)this.mControllerObj);
            return volumeInfoObj != null ? new PlaybackInfo(MediaControllerCompatApi21.PlaybackInfo.getPlaybackType((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getLegacyAudioStream((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getVolumeControl((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getMaxVolume((Object)volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getCurrentVolume((Object)volumeInfoObj)) : null;
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            MediaControllerCompatApi21.sendCommand((Object)this.mControllerObj, (String)command, (Bundle)params, (ResultReceiver)cb);
        }

        @Override
        public Object getMediaController() {
            return this.mControllerObj;
        }
    }

    static class MediaControllerImplBase
    implements MediaControllerImpl {
        MediaControllerImplBase() {
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
        }

        @Override
        public void unregisterCallback(Callback callback) {
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            return false;
        }

        @Override
        public TransportControls getTransportControls() {
            return null;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            return null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            return null;
        }

        @Override
        public int getRatingType() {
            return 0;
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            return null;
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
        }

        @Override
        public Object getMediaController() {
            return null;
        }
    }

    static interface MediaControllerImpl {
        public void registerCallback(Callback var1, Handler var2);

        public void unregisterCallback(Callback var1);

        public boolean dispatchMediaButtonEvent(KeyEvent var1);

        public TransportControls getTransportControls();

        public PlaybackStateCompat getPlaybackState();

        public MediaMetadataCompat getMetadata();

        public int getRatingType();

        public PlaybackInfo getPlaybackInfo();

        public void sendCommand(String var1, Bundle var2, ResultReceiver var3);

        public Object getMediaController();
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final int mPlaybackType;
        private final int mAudioStream;
        private final int mVolumeControl;
        private final int mMaxVolume;
        private final int mCurrentVolume;

        PlaybackInfo(int type, int stream, int control, int max, int current) {
            this.mPlaybackType = type;
            this.mAudioStream = stream;
            this.mVolumeControl = control;
            this.mMaxVolume = max;
            this.mCurrentVolume = current;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getAudioStream() {
            return this.mAudioStream;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }
    }

    public static abstract class TransportControls {
        TransportControls() {
        }

        public abstract void play();

        public abstract void pause();

        public abstract void stop();

        public abstract void seekTo(long var1);

        public abstract void fastForward();

        public abstract void skipToNext();

        public abstract void rewind();

        public abstract void skipToPrevious();

        public abstract void setRating(RatingCompat var1);
    }

    public static abstract class Callback {
        final Object mCallbackObj = Build.VERSION.SDK_INT >= 21 ? MediaControllerCompatApi21.createCallback((MediaControllerCompatApi21.Callback)new StubApi21()) : null;

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String event, Bundle extras) {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
        }

        private class StubApi21
        implements MediaControllerCompatApi21.Callback {
            private StubApi21() {
            }

            public void onSessionDestroyed() {
                Callback.this.onSessionDestroyed();
            }

            public void onSessionEvent(String event, Bundle extras) {
                Callback.this.onSessionEvent(event, extras);
            }

            public void onPlaybackStateChanged(Object stateObj) {
                Callback.this.onPlaybackStateChanged(PlaybackStateCompat.fromPlaybackState(stateObj));
            }

            public void onMetadataChanged(Object metadataObj) {
                Callback.this.onMetadataChanged(MediaMetadataCompat.fromMediaMetadata(metadataObj));
            }
        }
    }
}

