/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.NavUtils;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBarActivityDelegate;
import android.support.v7.appcompat.R;
import android.support.v7.internal.app.ToolbarActionBar;
import android.support.v7.internal.app.WindowCallback;
import android.support.v7.internal.app.WindowDecorActionBar;
import android.support.v7.internal.view.StandaloneActionMode;
import android.support.v7.internal.view.menu.ListMenuPresenter;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.MenuPresenter;
import android.support.v7.internal.view.menu.MenuView;
import android.support.v7.internal.widget.ActionBarContextView;
import android.support.v7.internal.widget.DecorContentParent;
import android.support.v7.internal.widget.FitWindowsViewGroup;
import android.support.v7.internal.widget.ProgressBarCompat;
import android.support.v7.internal.widget.TintCheckBox;
import android.support.v7.internal.widget.TintCheckedTextView;
import android.support.v7.internal.widget.TintEditText;
import android.support.v7.internal.widget.TintRadioButton;
import android.support.v7.internal.widget.TintSpinner;
import android.support.v7.internal.widget.ViewStubCompat;
import android.support.v7.internal.widget.ViewUtils;
import android.support.v7.view.ActionMode;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;

class ActionBarActivityDelegateBase
extends ActionBarActivityDelegate
implements MenuBuilder.Callback {
    private static final String TAG = "ActionBarActivityDelegateBase";
    private DecorContentParent mDecorContentParent;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    ActionMode mActionMode;
    ActionBarContextView mActionModeView;
    PopupWindow mActionModePopup;
    Runnable mShowActionModePopup;
    private boolean mSubDecorInstalled;
    private ViewGroup mWindowDecor;
    private ViewGroup mSubDecor;
    private View mStatusGuard;
    private CharSequence mTitleToSet;
    private boolean mFeatureProgress;
    private boolean mFeatureIndeterminateProgress;
    private boolean mClosingActionMenu;
    private PanelFeatureState[] mPanels;
    private PanelFeatureState mPreparedPanel;
    private boolean mInvalidatePanelMenuPosted;
    private int mInvalidatePanelMenuFeatures;
    private final Runnable mInvalidatePanelMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if ((ActionBarActivityDelegateBase.this.mInvalidatePanelMenuFeatures & 1) != 0) {
                ActionBarActivityDelegateBase.this.doInvalidatePanelMenu(0);
            }
            if ((ActionBarActivityDelegateBase.this.mInvalidatePanelMenuFeatures & 0x100) != 0) {
                ActionBarActivityDelegateBase.this.doInvalidatePanelMenu(8);
            }
            ActionBarActivityDelegateBase.this.mInvalidatePanelMenuPosted = false;
            ActionBarActivityDelegateBase.this.mInvalidatePanelMenuFeatures = 0;
        }
    };
    private boolean mEnableDefaultActionBarUp;
    private ListMenuPresenter mToolbarListMenuPresenter;
    private Rect mTempRect1;
    private Rect mTempRect2;

    ActionBarActivityDelegateBase(ActionBarActivity activity) {
        super(activity);
    }

    @Override
    void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mWindowDecor = (ViewGroup)this.mActivity.getWindow().getDecorView();
        if (NavUtils.getParentActivityName((Activity)this.mActivity) != null) {
            ActionBar ab = this.getSupportActionBar();
            if (ab == null) {
                this.mEnableDefaultActionBarUp = true;
            } else {
                ab.setDefaultDisplayHomeAsUpEnabled(true);
            }
        }
    }

    @Override
    public ActionBar createSupportActionBar() {
        this.ensureSubDecor();
        WindowDecorActionBar ab = new WindowDecorActionBar(this.mActivity, this.mOverlayActionBar);
        ((ActionBar)ab).setDefaultDisplayHomeAsUpEnabled(this.mEnableDefaultActionBarUp);
        return ab;
    }

    @Override
    void setSupportActionBar(Toolbar toolbar) {
        ActionBar ab = this.getSupportActionBar();
        if (ab instanceof WindowDecorActionBar) {
            throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_ACTION_BAR and set windowActionBar to false in your theme to use a Toolbar instead.");
        }
        if (ab instanceof ToolbarActionBar) {
            ((ToolbarActionBar)ab).setListMenuPresenter(null);
        }
        ToolbarActionBar tbab = new ToolbarActionBar(toolbar, this.mActivity.getTitle(), this.mActivity.getWindow(), this.mDefaultWindowCallback);
        this.ensureToolbarListMenuPresenter();
        tbab.setListMenuPresenter(this.mToolbarListMenuPresenter);
        this.setSupportActionBar(tbab);
        this.setWindowCallback(tbab.getWrappedWindowCallback());
        tbab.invalidateOptionsMenu();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        ActionBar ab;
        if (this.mHasActionBar && this.mSubDecorInstalled && (ab = this.getSupportActionBar()) != null) {
            ab.onConfigurationChanged(newConfig);
        }
    }

    @Override
    public void onStop() {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(false);
        }
    }

    @Override
    public void onPostResume() {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(true);
        }
    }

    @Override
    public void setContentView(View v) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mActivity.findViewById(0x1020002);
        contentParent.removeAllViews();
        contentParent.addView(v);
        this.mActivity.onSupportContentChanged();
    }

    @Override
    public void setContentView(int resId) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mActivity.findViewById(0x1020002);
        contentParent.removeAllViews();
        this.mActivity.getLayoutInflater().inflate(resId, contentParent);
        this.mActivity.onSupportContentChanged();
    }

    @Override
    public void setContentView(View v, ViewGroup.LayoutParams lp) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mActivity.findViewById(0x1020002);
        contentParent.removeAllViews();
        contentParent.addView(v, lp);
        this.mActivity.onSupportContentChanged();
    }

    @Override
    public void addContentView(View v, ViewGroup.LayoutParams lp) {
        this.ensureSubDecor();
        ViewGroup contentParent = (ViewGroup)this.mActivity.findViewById(0x1020002);
        contentParent.addView(v, lp);
        this.mActivity.onSupportContentChanged();
    }

    @Override
    public void onContentChanged() {
    }

    final void ensureSubDecor() {
        if (!this.mSubDecorInstalled) {
            if (this.mHasActionBar) {
                TypedValue outValue = new TypedValue();
                this.mActivity.getTheme().resolveAttribute(R.attr.actionBarTheme, outValue, true);
                ActionBarActivity themedContext = outValue.resourceId != 0 ? new ContextThemeWrapper((Context)this.mActivity, outValue.resourceId) : this.mActivity;
                this.mSubDecor = (ViewGroup)LayoutInflater.from((Context)themedContext).inflate(R.layout.abc_screen_toolbar, null);
                this.mDecorContentParent = (DecorContentParent)this.mSubDecor.findViewById(R.id.decor_content_parent);
                this.mDecorContentParent.setWindowCallback(this.getWindowCallback());
                if (this.mOverlayActionBar) {
                    this.mDecorContentParent.initFeature(9);
                }
                if (this.mFeatureProgress) {
                    this.mDecorContentParent.initFeature(2);
                }
                if (this.mFeatureIndeterminateProgress) {
                    this.mDecorContentParent.initFeature(5);
                }
            } else {
                this.mSubDecor = this.mOverlayActionMode ? (ViewGroup)LayoutInflater.from((Context)this.mActivity).inflate(R.layout.abc_screen_simple_overlay_action_mode, null) : (ViewGroup)LayoutInflater.from((Context)this.mActivity).inflate(R.layout.abc_screen_simple, null);
                if (Build.VERSION.SDK_INT >= 21) {
                    ViewCompat.setOnApplyWindowInsetsListener((View)this.mSubDecor, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                            int newTop;
                            int top = insets.getSystemWindowInsetTop();
                            if (top != (newTop = ActionBarActivityDelegateBase.this.updateStatusGuard(top))) {
                                return insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), newTop, insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
                            }
                            return insets;
                        }
                    });
                } else {
                    ((FitWindowsViewGroup)this.mSubDecor).setOnFitSystemWindowsListener(new FitWindowsViewGroup.OnFitSystemWindowsListener(){

                        @Override
                        public void onFitSystemWindows(Rect insets) {
                            insets.top = ActionBarActivityDelegateBase.this.updateStatusGuard(insets.top);
                        }
                    });
                }
            }
            ViewUtils.makeOptionalFitsSystemWindows((View)this.mSubDecor);
            this.mActivity.superSetContentView((View)this.mSubDecor);
            View decorContent = this.mActivity.findViewById(0x1020002);
            decorContent.setId(-1);
            View abcContent = this.mActivity.findViewById(R.id.action_bar_activity_content);
            abcContent.setId(0x1020002);
            if (decorContent instanceof FrameLayout) {
                ((FrameLayout)decorContent).setForeground(null);
            }
            if (this.mTitleToSet != null && this.mDecorContentParent != null) {
                this.mDecorContentParent.setWindowTitle(this.mTitleToSet);
                this.mTitleToSet = null;
            }
            this.applyFixedSizeWindow();
            this.onSubDecorInstalled();
            this.mSubDecorInstalled = true;
            PanelFeatureState st = this.getPanelState(0, false);
            if (!(this.isDestroyed() || st != null && st.menu != null)) {
                this.invalidatePanelMenu(8);
            }
        }
    }

    void onSubDecorInstalled() {
    }

    private void applyFixedSizeWindow() {
        TypedValue tvh;
        TypedValue tvw;
        TypedArray a = this.mActivity.obtainStyledAttributes(R.styleable.Theme);
        TypedValue mFixedWidthMajor = null;
        TypedValue mFixedWidthMinor = null;
        TypedValue mFixedHeightMajor = null;
        TypedValue mFixedHeightMinor = null;
        if (a.hasValue(R.styleable.Theme_windowFixedWidthMajor)) {
            if (mFixedWidthMajor == null) {
                mFixedWidthMajor = new TypedValue();
            }
            a.getValue(R.styleable.Theme_windowFixedWidthMajor, mFixedWidthMajor);
        }
        if (a.hasValue(R.styleable.Theme_windowFixedWidthMinor)) {
            if (mFixedWidthMinor == null) {
                mFixedWidthMinor = new TypedValue();
            }
            a.getValue(R.styleable.Theme_windowFixedWidthMinor, mFixedWidthMinor);
        }
        if (a.hasValue(R.styleable.Theme_windowFixedHeightMajor)) {
            if (mFixedHeightMajor == null) {
                mFixedHeightMajor = new TypedValue();
            }
            a.getValue(R.styleable.Theme_windowFixedHeightMajor, mFixedHeightMajor);
        }
        if (a.hasValue(R.styleable.Theme_windowFixedHeightMinor)) {
            if (mFixedHeightMinor == null) {
                mFixedHeightMinor = new TypedValue();
            }
            a.getValue(R.styleable.Theme_windowFixedHeightMinor, mFixedHeightMinor);
        }
        DisplayMetrics metrics = this.mActivity.getResources().getDisplayMetrics();
        boolean isPortrait = metrics.widthPixels < metrics.heightPixels;
        int w = -1;
        int h = -1;
        TypedValue typedValue = tvw = isPortrait ? mFixedWidthMinor : mFixedWidthMajor;
        if (tvw != null && tvw.type != 0) {
            if (tvw.type == 5) {
                w = (int)tvw.getDimension(metrics);
            } else if (tvw.type == 6) {
                w = (int)tvw.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels);
            }
        }
        TypedValue typedValue2 = tvh = isPortrait ? mFixedHeightMajor : mFixedHeightMinor;
        if (tvh != null && tvh.type != 0) {
            if (tvh.type == 5) {
                h = (int)tvh.getDimension(metrics);
            } else if (tvh.type == 6) {
                h = (int)tvh.getFraction((float)metrics.heightPixels, (float)metrics.heightPixels);
            }
        }
        if (w != -1 || h != -1) {
            this.mActivity.getWindow().setLayout(w, h);
        }
        a.recycle();
    }

    @Override
    public boolean supportRequestWindowFeature(int featureId) {
        switch (featureId) {
            case 8: {
                this.mHasActionBar = true;
                return true;
            }
            case 9: {
                this.mOverlayActionBar = true;
                return true;
            }
            case 10: {
                this.mOverlayActionMode = true;
                return true;
            }
            case 2: {
                this.mFeatureProgress = true;
                return true;
            }
            case 5: {
                this.mFeatureIndeterminateProgress = true;
                return true;
            }
        }
        return this.mActivity.requestWindowFeature(featureId);
    }

    @Override
    public void onTitleChanged(CharSequence title) {
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setWindowTitle(title);
        } else if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setWindowTitle(title);
        } else {
            this.mTitleToSet = title;
        }
    }

    @Override
    public View onCreatePanelView(int featureId) {
        View panelView = null;
        if (this.mActionMode == null) {
            WindowCallback callback = this.getWindowCallback();
            if (callback != null) {
                panelView = callback.onCreatePanelView(featureId);
            }
            if (panelView == null && this.mToolbarListMenuPresenter == null) {
                PanelFeatureState st = this.getPanelState(featureId, true);
                this.openPanel(st, null);
                if (st.isOpen) {
                    panelView = st.shownPanelView;
                }
            }
        }
        return panelView;
    }

    @Override
    public boolean onCreatePanelMenu(int featureId, Menu menu) {
        if (featureId != 0) {
            return this.getWindowCallback().onCreatePanelMenu(featureId, menu);
        }
        return false;
    }

    @Override
    public boolean onPreparePanel(int featureId, View view, Menu menu) {
        if (featureId != 0) {
            return this.getWindowCallback().onPreparePanel(featureId, view, menu);
        }
        return false;
    }

    @Override
    public void onPanelClosed(int featureId, Menu menu) {
        PanelFeatureState st = this.getPanelState(featureId, false);
        if (st != null) {
            this.closePanel(st, false);
        }
        if (featureId == 8) {
            ActionBar ab = this.getSupportActionBar();
            if (ab != null) {
                ab.dispatchMenuVisibilityChanged(false);
            }
        } else if (!this.isDestroyed()) {
            this.mActivity.superOnPanelClosed(featureId, menu);
        }
    }

    @Override
    boolean onMenuOpened(int featureId, Menu menu) {
        if (featureId == 8) {
            ActionBar ab = this.getSupportActionBar();
            if (ab != null) {
                ab.dispatchMenuVisibilityChanged(true);
            }
            return true;
        }
        return this.mActivity.superOnMenuOpened(featureId, menu);
    }

    @Override
    public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
        PanelFeatureState panel;
        WindowCallback cb = this.getWindowCallback();
        if (cb != null && !this.isDestroyed() && (panel = this.findMenuPanel((Menu)menu.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    @Override
    public void onMenuModeChange(MenuBuilder menu) {
        this.reopenMenu(menu, true);
    }

    @Override
    public ActionMode startSupportActionMode(ActionMode.Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("ActionMode callback can not be null.");
        }
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapper wrappedCallback = new ActionModeCallbackWrapper(callback);
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            this.mActionMode = ab.startActionMode(wrappedCallback);
            if (this.mActionMode != null) {
                this.mActivity.onSupportActionModeStarted(this.mActionMode);
            }
        }
        if (this.mActionMode == null) {
            this.mActionMode = this.startSupportActionModeFromWindow(wrappedCallback);
        }
        return this.mActionMode;
    }

    @Override
    public void supportInvalidateOptionsMenu() {
        ActionBar ab = this.getSupportActionBar();
        if (ab != null && ab.invalidateOptionsMenu()) {
            return;
        }
        this.invalidatePanelMenu(0);
    }

    @Override
    ActionMode startSupportActionModeFromWindow(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapper wrappedCallback = new ActionModeCallbackWrapper(callback);
        Context context = this.getActionBarThemedContext();
        if (this.mActionModeView == null) {
            if (this.mIsFloating) {
                this.mActionModeView = new ActionBarContextView(context);
                this.mActionModePopup = new PopupWindow(context, null, R.attr.actionModePopupWindowStyle);
                this.mActionModePopup.setContentView((View)this.mActionModeView);
                this.mActionModePopup.setWidth(-1);
                TypedValue heightValue = new TypedValue();
                this.mActivity.getTheme().resolveAttribute(R.attr.actionBarSize, heightValue, true);
                int height = TypedValue.complexToDimensionPixelSize((int)heightValue.data, (DisplayMetrics)this.mActivity.getResources().getDisplayMetrics());
                this.mActionModeView.setContentHeight(height);
                this.mActionModePopup.setHeight(-2);
                this.mShowActionModePopup = new Runnable(){

                    @Override
                    public void run() {
                        ActionBarActivityDelegateBase.this.mActionModePopup.showAtLocation((View)ActionBarActivityDelegateBase.this.mActionModeView, 55, 0, 0);
                    }
                };
            } else {
                ViewStubCompat stub = (ViewStubCompat)this.mActivity.findViewById(R.id.action_mode_bar_stub);
                if (stub != null) {
                    stub.setLayoutInflater(LayoutInflater.from((Context)context));
                    this.mActionModeView = (ActionBarContextView)stub.inflate();
                }
            }
        }
        if (this.mActionModeView != null) {
            this.mActionModeView.killMode();
            StandaloneActionMode mode = new StandaloneActionMode(context, this.mActionModeView, wrappedCallback, this.mActionModePopup == null);
            if (callback.onCreateActionMode(mode, ((ActionMode)mode).getMenu())) {
                ((ActionMode)mode).invalidate();
                this.mActionModeView.initForMode(mode);
                this.mActionModeView.setVisibility(0);
                this.mActionMode = mode;
                if (this.mActionModePopup != null) {
                    this.mActivity.getWindow().getDecorView().post(this.mShowActionModePopup);
                }
                this.mActionModeView.sendAccessibilityEvent(32);
                if (this.mActionModeView.getParent() != null) {
                    ViewCompat.requestApplyInsets((View)((View)this.mActionModeView.getParent()));
                }
            } else {
                this.mActionMode = null;
            }
        }
        if (this.mActionMode != null && this.mActivity != null) {
            this.mActivity.onSupportActionModeStarted(this.mActionMode);
        }
        return this.mActionMode;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            return true;
        }
        ActionBar ab = this.getSupportActionBar();
        return ab != null && ab.collapseActionView();
    }

    @Override
    void setSupportProgressBarVisibility(boolean visible) {
        this.updateProgressBars(visible ? -1 : -2);
    }

    @Override
    void setSupportProgressBarIndeterminateVisibility(boolean visible) {
        this.updateProgressBars(visible ? -1 : -2);
    }

    @Override
    void setSupportProgressBarIndeterminate(boolean indeterminate) {
        this.updateProgressBars(indeterminate ? -3 : -4);
    }

    @Override
    void setSupportProgress(int progress) {
        this.updateProgressBars(0 + progress);
    }

    @Override
    int getHomeAsUpIndicatorAttrId() {
        return R.attr.homeAsUpIndicator;
    }

    @Override
    boolean onKeyShortcut(int keyCode, KeyEvent ev) {
        boolean handled;
        if (this.mPreparedPanel != null && (handled = this.performPanelShortcut(this.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
            if (this.mPreparedPanel != null) {
                this.mPreparedPanel.isHandled = true;
            }
            return true;
        }
        if (this.mPreparedPanel == null) {
            PanelFeatureState st = this.getPanelState(0, true);
            this.preparePanel(st, ev);
            handled = this.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
            st.isPrepared = false;
            if (handled) {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.onKeyShortcut(keyCode, event);
    }

    @Override
    View createView(String name, @NonNull AttributeSet attrs) {
        if (Build.VERSION.SDK_INT < 21) {
            switch (name) {
                case "EditText": {
                    return new TintEditText((Context)this.mActivity, attrs);
                }
                case "Spinner": {
                    return new TintSpinner((Context)this.mActivity, attrs);
                }
                case "CheckBox": {
                    return new TintCheckBox((Context)this.mActivity, attrs);
                }
                case "RadioButton": {
                    return new TintRadioButton((Context)this.mActivity, attrs);
                }
                case "CheckedTextView": {
                    return new TintCheckedTextView((Context)this.mActivity, attrs);
                }
            }
        }
        return null;
    }

    private void updateProgressBars(int value) {
        ProgressBarCompat circularProgressBar = this.getCircularProgressBar();
        ProgressBarCompat horizontalProgressBar = this.getHorizontalProgressBar();
        if (value == -1) {
            if (this.mFeatureProgress) {
                int level = horizontalProgressBar.getProgress();
                int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                horizontalProgressBar.setVisibility(visibility);
            }
            if (this.mFeatureIndeterminateProgress) {
                circularProgressBar.setVisibility(0);
            }
        } else if (value == -2) {
            if (this.mFeatureProgress) {
                horizontalProgressBar.setVisibility(8);
            }
            if (this.mFeatureIndeterminateProgress) {
                circularProgressBar.setVisibility(8);
            }
        } else if (value == -3) {
            horizontalProgressBar.setIndeterminate(true);
        } else if (value == -4) {
            horizontalProgressBar.setIndeterminate(false);
        } else if (0 <= value && value <= 10000) {
            horizontalProgressBar.setProgress(value - 0);
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        }
    }

    private void openPanel(int featureId, KeyEvent event) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfigurationCompat.hasPermanentMenuKey((ViewConfiguration)ViewConfiguration.get((Context)this.mActivity))) {
            this.mDecorContentParent.showOverflowMenu();
        } else {
            this.openPanel(this.getPanelState(featureId, true), event);
        }
    }

    private void openPanel(PanelFeatureState st, KeyEvent event) {
        WindowCallback cb;
        if (st.isOpen || this.isDestroyed()) {
            return;
        }
        if (st.featureId == 0) {
            boolean isHoneycombApp;
            ActionBarActivity context = this.mActivity;
            Configuration config = context.getResources().getConfiguration();
            boolean isXLarge = (config.screenLayout & 0xF) == 4;
            boolean bl = isHoneycombApp = context.getApplicationInfo().targetSdkVersion >= 11;
            if (isXLarge && isHoneycombApp) {
                return;
            }
        }
        if ((cb = this.getWindowCallback()) != null && !cb.onMenuOpened(st.featureId, (Menu)st.menu)) {
            this.closePanel(st, true);
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        if (st.decorView == null || st.refreshDecorView) {
            this.initializePanelDecor(st);
        }
        if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
            return;
        }
        st.isHandled = false;
        st.isOpen = true;
    }

    private void initializePanelDecor(PanelFeatureState st) {
        st.decorView = this.mWindowDecor;
        st.setStyle(this.getActionBarThemedContext());
    }

    private void reopenMenu(MenuBuilder menu, boolean toggleMenuMode) {
        if (this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && (!ViewConfigurationCompat.hasPermanentMenuKey((ViewConfiguration)ViewConfiguration.get((Context)this.mActivity)) || this.mDecorContentParent.isOverflowMenuShowPending())) {
            WindowCallback cb = this.getWindowCallback();
            if (!this.mDecorContentParent.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.isDestroyed()) {
                    if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                        this.mWindowDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
                        this.mInvalidatePanelMenuRunnable.run();
                    }
                    PanelFeatureState st = this.getPanelState(0, true);
                    if (st.menu != null && !st.refreshMenuContent && cb.onPreparePanel(0, null, (Menu)st.menu)) {
                        cb.onMenuOpened(8, (Menu)st.menu);
                        this.mDecorContentParent.showOverflowMenu();
                    }
                }
            } else {
                this.mDecorContentParent.hideOverflowMenu();
                if (!this.isDestroyed()) {
                    PanelFeatureState st = this.getPanelState(0, true);
                    this.mActivity.onPanelClosed(8, (Menu)st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, true);
        st.refreshDecorView = true;
        this.closePanel(st, false);
        this.openPanel(st, null);
    }

    private void showProgressBars(ProgressBarCompat horizontalProgressBar, ProgressBarCompat spinnyProgressBar) {
        if (this.mFeatureIndeterminateProgress && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if (this.mFeatureProgress && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private void hideProgressBars(ProgressBarCompat horizontalProgressBar, ProgressBarCompat spinnyProgressBar) {
        if (this.mFeatureIndeterminateProgress && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.setVisibility(4);
        }
        if (this.mFeatureProgress && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.setVisibility(4);
        }
    }

    private ProgressBarCompat getCircularProgressBar() {
        ProgressBarCompat pb = (ProgressBarCompat)this.mActivity.findViewById(R.id.progress_circular);
        if (pb != null) {
            pb.setVisibility(4);
        }
        return pb;
    }

    private ProgressBarCompat getHorizontalProgressBar() {
        ProgressBarCompat pb = (ProgressBarCompat)this.mActivity.findViewById(R.id.progress_horizontal);
        if (pb != null) {
            pb.setVisibility(4);
        }
        return pb;
    }

    private boolean initializePanelMenu(PanelFeatureState st) {
        ActionBarActivity context = this.mActivity;
        if ((st.featureId == 0 || st.featureId == 8) && this.mDecorContentParent != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme baseTheme = context.getTheme();
            baseTheme.resolveAttribute(R.attr.actionBarTheme, outValue, true);
            Resources.Theme widgetTheme = null;
            if (outValue.resourceId != 0) {
                widgetTheme = context.getResources().newTheme();
                widgetTheme.setTo(baseTheme);
                widgetTheme.applyStyle(outValue.resourceId, true);
                widgetTheme.resolveAttribute(R.attr.actionBarWidgetTheme, outValue, true);
            } else {
                baseTheme.resolveAttribute(R.attr.actionBarWidgetTheme, outValue, true);
            }
            if (outValue.resourceId != 0) {
                if (widgetTheme == null) {
                    widgetTheme = context.getResources().newTheme();
                    widgetTheme.setTo(baseTheme);
                }
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            if (widgetTheme != null) {
                context = new ContextThemeWrapper((Context)context, 0);
                context.getTheme().setTo(widgetTheme);
            }
        }
        MenuBuilder menu = new MenuBuilder((Context)context);
        menu.setCallback(this);
        st.setMenu(menu);
        return true;
    }

    private boolean initializePanelContent(PanelFeatureState st) {
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        MenuView menuView = st.getListMenuView(this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)menuView;
        return st.shownPanelView != null;
    }

    private boolean preparePanel(PanelFeatureState st, KeyEvent event) {
        boolean isActionBarMenu;
        if (this.isDestroyed()) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        boolean bl = isActionBarMenu = st.featureId == 0 || st.featureId == 8;
        if (isActionBarMenu && this.mDecorContentParent != null) {
            this.mDecorContentParent.setMenuPrepared();
        }
        if (st.menu == null || st.refreshMenuContent) {
            if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                return false;
            }
            if (isActionBarMenu && this.mDecorContentParent != null) {
                if (this.mActionMenuPresenterCallback == null) {
                    this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                }
                this.mDecorContentParent.setMenu((Menu)st.menu, this.mActionMenuPresenterCallback);
            }
            st.menu.stopDispatchingItemsChanged();
            if (!this.getWindowCallback().onCreatePanelMenu(st.featureId, (Menu)st.menu)) {
                st.setMenu(null);
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                }
                return false;
            }
            st.refreshMenuContent = false;
        }
        st.menu.stopDispatchingItemsChanged();
        if (st.frozenActionViewState != null) {
            st.menu.restoreActionViewStates(st.frozenActionViewState);
            st.frozenActionViewState = null;
        }
        if (!this.getWindowCallback().onPreparePanel(0, null, (Menu)st.menu)) {
            if (isActionBarMenu && this.mDecorContentParent != null) {
                this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
            }
            st.menu.startDispatchingItemsChanged();
            return false;
        }
        KeyCharacterMap kmap = KeyCharacterMap.load((int)(event != null ? event.getDeviceId() : -1));
        st.qwertyMode = kmap.getKeyboardType() != 1;
        st.menu.setQwertyMode(st.qwertyMode);
        st.menu.startDispatchingItemsChanged();
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    private void checkCloseActionMenu(MenuBuilder menu) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        WindowCallback cb = this.getWindowCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onPanelClosed(8, (Menu)menu);
        }
        this.mClosingActionMenu = false;
    }

    private void closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(st.menu);
            return;
        }
        if (st.isOpen && doCallback) {
            this.callOnPanelClosed(st.featureId, st, null);
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        st.refreshDecorView = true;
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
        }
    }

    private void callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu) {
        if (menu == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        this.getWindowCallback().onPanelClosed(featureId, (Menu)menu);
    }

    private PanelFeatureState findMenuPanel(Menu menu) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu) continue;
            return panel;
        }
        return null;
    }

    private PanelFeatureState getPanelState(int featureId, boolean required) {
        PanelFeatureState st;
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new PanelFeatureState(featureId);
        }
        return st;
    }

    final boolean performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem()) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled && (flags & 1) == 0 && this.mDecorContentParent == null) {
            this.closePanel(st, true);
        }
        return handled;
    }

    private void invalidatePanelMenu(int featureId) {
        this.mInvalidatePanelMenuFeatures |= 1 << featureId;
        if (!this.mInvalidatePanelMenuPosted && this.mWindowDecor != null) {
            ViewCompat.postOnAnimation((View)this.mWindowDecor, (Runnable)this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    private void doInvalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 8 || featureId == 0) && this.mDecorContentParent != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    private int updateStatusGuard(int insetTop) {
        boolean showStatusGuard = false;
        if (this.mActionModeView != null && this.mActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mActionModeView.getLayoutParams();
            boolean mlpChanged = false;
            if (this.mActionModeView.isShown()) {
                int newMargin;
                if (this.mTempRect1 == null) {
                    this.mTempRect1 = new Rect();
                    this.mTempRect2 = new Rect();
                }
                Rect insets = this.mTempRect1;
                Rect localInsets = this.mTempRect2;
                insets.set(0, insetTop, 0, 0);
                ViewUtils.computeFitSystemWindows((View)this.mSubDecor, insets, localInsets);
                int n = newMargin = localInsets.top == 0 ? insetTop : 0;
                if (mlp.topMargin != newMargin) {
                    mlpChanged = true;
                    mlp.topMargin = insetTop;
                    if (this.mStatusGuard == null) {
                        this.mStatusGuard = new View((Context)this.mActivity);
                        this.mStatusGuard.setBackgroundColor(this.mActivity.getResources().getColor(R.color.abc_input_method_navigation_guard));
                        this.mSubDecor.addView(this.mStatusGuard, -1, new ViewGroup.LayoutParams(-1, insetTop));
                    } else {
                        ViewGroup.LayoutParams lp = this.mStatusGuard.getLayoutParams();
                        if (lp.height != insetTop) {
                            lp.height = insetTop;
                            this.mStatusGuard.setLayoutParams(lp);
                        }
                    }
                }
                boolean bl = showStatusGuard = this.mStatusGuard != null;
                if (!this.mOverlayActionMode && showStatusGuard) {
                    insetTop = 0;
                }
            } else if (mlp.topMargin != 0) {
                mlpChanged = true;
                mlp.topMargin = 0;
            }
            if (mlpChanged) {
                this.mActionModeView.setLayoutParams((ViewGroup.LayoutParams)mlp);
            }
        }
        if (this.mStatusGuard != null) {
            this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
        }
        return insetTop;
    }

    private void ensureToolbarListMenuPresenter() {
        if (this.mToolbarListMenuPresenter == null) {
            TypedValue outValue = new TypedValue();
            this.mActivity.getTheme().resolveAttribute(R.attr.panelMenuListTheme, outValue, true);
            ContextThemeWrapper context = new ContextThemeWrapper((Context)this.mActivity, outValue.resourceId != 0 ? outValue.resourceId : R.style.Theme_AppCompat_CompactMenu);
            this.mToolbarListMenuPresenter = new ListMenuPresenter((Context)context, R.layout.abc_list_menu_item_layout);
        }
    }

    private static final class PanelFeatureState {
        int featureId;
        ViewGroup decorView;
        View shownPanelView;
        MenuBuilder menu;
        ListMenuPresenter listMenuPresenter;
        Context listPresenterContext;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        PanelFeatureState(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        public boolean hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            return this.listMenuPresenter.getAdapter().getCount() > 0;
        }

        public void clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.listMenuPresenter = null;
        }

        void setStyle(Context context) {
            TypedValue outValue = new TypedValue();
            Resources.Theme widgetTheme = context.getResources().newTheme();
            widgetTheme.setTo(context.getTheme());
            widgetTheme.resolveAttribute(R.attr.actionBarPopupTheme, outValue, true);
            if (outValue.resourceId != 0) {
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            widgetTheme.resolveAttribute(R.attr.panelMenuListTheme, outValue, true);
            if (outValue.resourceId != 0) {
                widgetTheme.applyStyle(outValue.resourceId, true);
            } else {
                widgetTheme.applyStyle(R.style.Theme_AppCompat_CompactMenu, true);
            }
            context = new ContextThemeWrapper(context, 0);
            context.getTheme().setTo(widgetTheme);
            this.listPresenterContext = context;
        }

        void setMenu(MenuBuilder menu) {
            if (menu == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.menu = menu;
            if (menu != null && this.listMenuPresenter != null) {
                menu.addMenuPresenter(this.listMenuPresenter);
            }
        }

        MenuView getListMenuView(MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(this.listPresenterContext, R.layout.abc_list_menu_item_layout);
                this.listMenuPresenter.setCallback(cb);
                this.menu.addMenuPresenter(this.listMenuPresenter);
            }
            MenuView result = this.listMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.frozenMenuState = savedState.menuState;
            this.shownPanelView = null;
            this.decorView = null;
        }

        void applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        private static class SavedState
        implements Parcelable {
            int featureId;
            boolean isOpen;
            Bundle menuState;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                public SavedState createFromParcel(Parcel in) {
                    return SavedState.readFromParcel(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            private SavedState() {
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            private static SavedState readFromParcel(Parcel source) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                boolean bl = savedState.isOpen = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle();
                }
                return savedState;
            }
        }
    }

    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        private ActionMenuPresenterCallback() {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            WindowCallback cb = ActionBarActivityDelegateBase.this.getWindowCallback();
            if (cb != null) {
                cb.onMenuOpened(8, (Menu)subMenu);
            }
            return true;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            ActionBarActivityDelegateBase.this.checkCloseActionMenu(menu);
        }
    }

    private final class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        private PanelMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu.getRootMenu();
            boolean isSubMenu = parentMenu != menu;
            PanelFeatureState panel = ActionBarActivityDelegateBase.this.findMenuPanel((Menu)(isSubMenu ? parentMenu : menu));
            if (panel != null) {
                if (isSubMenu) {
                    ActionBarActivityDelegateBase.this.callOnPanelClosed(panel.featureId, panel, (Menu)parentMenu);
                    ActionBarActivityDelegateBase.this.closePanel(panel, true);
                } else {
                    ActionBarActivityDelegateBase.this.mActivity.closeOptionsMenu();
                    ActionBarActivityDelegateBase.this.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            WindowCallback cb;
            if (subMenu == null && ActionBarActivityDelegateBase.this.mHasActionBar && (cb = ActionBarActivityDelegateBase.this.getWindowCallback()) != null && !ActionBarActivityDelegateBase.this.isDestroyed()) {
                cb.onMenuOpened(8, (Menu)subMenu);
            }
            return true;
        }
    }

    private class ActionModeCallbackWrapper
    implements ActionMode.Callback {
        private ActionMode.Callback mWrapped;

        public ActionModeCallbackWrapper(ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onCreateActionMode(mode, menu);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            if (ActionBarActivityDelegateBase.this.mActionModePopup != null) {
                ActionBarActivityDelegateBase.this.mActivity.getWindow().getDecorView().removeCallbacks(ActionBarActivityDelegateBase.this.mShowActionModePopup);
                ActionBarActivityDelegateBase.this.mActionModePopup.dismiss();
            } else if (ActionBarActivityDelegateBase.this.mActionModeView != null) {
                ActionBarActivityDelegateBase.this.mActionModeView.setVisibility(8);
                if (ActionBarActivityDelegateBase.this.mActionModeView.getParent() != null) {
                    ViewCompat.requestApplyInsets((View)((View)ActionBarActivityDelegateBase.this.mActionModeView.getParent()));
                }
            }
            if (ActionBarActivityDelegateBase.this.mActionModeView != null) {
                ActionBarActivityDelegateBase.this.mActionModeView.removeAllViews();
            }
            if (ActionBarActivityDelegateBase.this.mActivity != null) {
                try {
                    ActionBarActivityDelegateBase.this.mActivity.onSupportActionModeFinished(ActionBarActivityDelegateBase.this.mActionMode);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            ActionBarActivityDelegateBase.this.mActionMode = null;
        }
    }
}

