/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.graphics.BitmapCompatHoneycombMr1;
import android.support.v4.graphics.BitmapCompatJellybeanMR2;
import android.support.v4.graphics.BitmapCompatKitKat;

public class BitmapCompat {
    static final BitmapImpl IMPL;

    public static boolean hasMipMap(Bitmap bitmap) {
        return IMPL.hasMipMap(bitmap);
    }

    public static void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        IMPL.setHasMipMap(bitmap, hasMipMap);
    }

    public static int getAllocationByteCount(Bitmap bitmap) {
        return IMPL.getAllocationByteCount(bitmap);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 19 ? new KitKatBitmapCompatImpl() : (version >= 18 ? new JbMr2BitmapCompatImpl() : (version >= 12 ? new HcMr1BitmapCompatImpl() : new BaseBitmapImpl()));
    }

    static class KitKatBitmapCompatImpl
    extends JbMr2BitmapCompatImpl {
        KitKatBitmapCompatImpl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return BitmapCompatKitKat.getAllocationByteCount((Bitmap)bitmap);
        }
    }

    static class JbMr2BitmapCompatImpl
    extends HcMr1BitmapCompatImpl {
        JbMr2BitmapCompatImpl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return BitmapCompatJellybeanMR2.hasMipMap((Bitmap)bitmap);
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
            BitmapCompatJellybeanMR2.setHasMipMap((Bitmap)bitmap, (boolean)hasMipMap);
        }
    }

    static class HcMr1BitmapCompatImpl
    extends BaseBitmapImpl {
        HcMr1BitmapCompatImpl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return BitmapCompatHoneycombMr1.getAllocationByteCount((Bitmap)bitmap);
        }
    }

    static class BaseBitmapImpl
    implements BitmapImpl {
        BaseBitmapImpl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return false;
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return bitmap.getRowBytes() * bitmap.getHeight();
        }
    }

    static interface BitmapImpl {
        public boolean hasMipMap(Bitmap var1);

        public void setHasMipMap(Bitmap var1, boolean var2);

        public int getAllocationByteCount(Bitmap var1);
    }
}

