// 06_06_przykad_EEPROM

#include <EEPROM.h>

const int lockPin = 13;
const byte codeSetMarkerValue = 123;
const int defaultCode = 1234;

int code;
boolean locked = true;

void setup()
{
  pinMode(lockPin, OUTPUT);
  Serial.begin(9600);
  while (! Serial) {}; // Czeka na uruchomienie portu szeregowego(tylko pytka Leonardo)
  lock();
  Serial.println("Wpisz polecenie U oraz kod otwierajacy");
  Serial.println("i L aby ponownie zamknac.");
  Serial.println("Aby zmienic kod wpisz polecenie C oraz nowy kod");
  initializeCode();
}

void loop()
{
  if (Serial.available())
  {
    char command = Serial.read();
    if (command == 'U')
    {
      attemptUnlock();
    }
    else if (command == 'L')
    {
      lock();
    }
    else if (command == 'C')
    {
      if (locked)
      {
        Serial.println("Nowy kod moze byc ustawiony tylko po otwarciu");
      }
      else
      {
        changeCode();
      }
    }
  }
}

void initializeCode()
{
  byte codeSetMarker = EEPROM.read(0);
  if (codeSetMarker == codeSetMarkerValue)
  {
    code = readSecretCodeFromEEPROM();
  }
  else
  {
    code = defaultCode;
  }
}

int readSecretCodeFromEEPROM()
{
  byte high = EEPROM.read(1);
  byte low = EEPROM.read(2);
  return (high << 8) + low;
}

void saveSecretCodeToEEPROM()
{
  EEPROM.write(0, codeSetMarkerValue);
  EEPROM.write(1, highByte(code));
  EEPROM.write(2, lowByte(code));
}

void attemptUnlock()
{
  if (code == Serial.parseInt())
  {
    unlock();
  }
  else
  {
    Serial.println("Nieprawidlowy kod");
  }
}

void lock()
{
  locked = true;
  Serial.println("ZAMKNIETE");
  digitalWrite(lockPin, LOW);
}

void unlock()
{
  locked = false;
  Serial.println("OTWARTE");
  digitalWrite(lockPin, HIGH);
}

void changeCode()
{
  code = Serial.parseInt();
  saveSecretCodeToEEPROM();
  Serial.print("Nowy kod:");
  Serial.println(code);
}
