// 12_04_GPS

#include <SoftwareSerial.h>

SoftwareSerial gpsSerial(10, 11); // Rx, Tx (złącze Tx nie jest używane)
const int sentenceSize = 80;

char sentence[sentenceSize];

void setup()
{
  Serial.begin(9600);
  gpsSerial.begin(9600);
}

void loop()
{
  static int i = 0;
  if (gpsSerial.available())
  {
    char ch = gpsSerial.read();
    if (ch != '\n' && i < sentenceSize)
    {
      sentence[i] = ch;
      i++;
    }
    else
    {
     sentence[i] = '\0';
     i = 0;
     Serial.println(sentence);
     //displayGPS();
    }
  }
}

void displayGPS()
{
  char field[20];
  getField(field, 0);
  if (strcmp(field, "$GPRMC") == 0)
  {
    Serial.print("Szer.: ");
    getField(field, 3);  // liczba
    Serial.print(field);
    getField(field, 4); // północ-południe (N/S)
    Serial.print(field);
    
    Serial.print(" Dług.: ");
    getField(field, 5);  // liczba
    Serial.print(field);
    getField(field, 6);  // wschód-zachód (E/W)
    Serial.println(field);
  }
}

void getField(char* buffer, int index)
{
  int sentencePos = 0;
  int fieldPos = 0;
  int commaCount = 0;
  while (sentencePos < sentenceSize)
  {
    if (sentence[sentencePos] == ',')
    {
      commaCount ++;
      sentencePos ++;
    }
    if (commaCount == index)
    {
      buffer[fieldPos] = sentence[sentencePos];
      fieldPos ++;
    }
    sentencePos ++;
  }
  buffer[fieldPos] = '\0';
}
