
// 14_05_esp32_server
// https://github.com/Pedroalbuquerque/ESP32WebServer

#include <WiFiClient.h>
#include <ESP32WebServer.h>
#include <WiFi.h>
#include <ESPmDNS.h>

const char* ssid = "";
const char* password = "";
const int relayPin = 22;

ESP32WebServer server(80);

void setup() {
  pinMode(relayPin, OUTPUT);
  Serial.begin(9600);
  connectToWiFi();
  server.on("/", HTTP_GET, handleRoot);
  server.begin();
  Serial.println("Serwer HTTP został uruchomiony");
}

void loop() {
  server.handleClient();
}

void connectToWiFi() {
  Serial.print("\n\nŁączenie z ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nPołączono z siecią Wi-Fi");  
  Serial.print("Adres IP: ");
  Serial.println(WiFi.localIP());
}

void handleRoot() {
  Serial.println("Otrzymano żądanie");
  if (server.arg(0)[0] == '1') {
    digitalWrite(relayPin, HIGH);
  }
  else {
    digitalWrite(relayPin, LOW);
  }
  String msg = "";
  msg += "<html><body>\n";
  msg += "<h1>Zdalny przekaźnik</h1>";
  msg += "<h2><a href='?a=1'/>Włącz</a></h2>";
  msg += "<h2><a href='?a=0'/>Wyłącz</a></h2>";
  msg += "</body></html>";
  
  server.send(200, "text/html", msg);
}
