#include <cstdlib>
#include <iostream>

#include <redis-cpp/execute.h>
#include <redis-cpp/stream.h>

int main() {
  try {
    auto stream = rediscpp::make_stream("localhost", "6379");

    auto const key = "mój_klucz";

    auto response = rediscpp::execute(*stream, "set", key,
                                      "Jakaś wartość klucza 'mój_klucz'", "ex", "60");

    std::cout << "Wstawianie klucza '" << key << "': " << response.as<std::string>()
              << std::endl;

    response = rediscpp::execute(*stream, "get", key);
    std::cout << "Pobieranie klucza '" << key << "': " << response.as<std::string>()
              << std::endl;
  } catch (std::exception const &e) {
    std::cerr << "Błąd: " << e.what() << std::endl;
    return EXIT_FAILURE;
  }
  return EXIT_SUCCESS;
}
