struct NonCopyable {
  NonCopyable() = default;
  NonCopyable(const NonCopyable &) = delete;
  NonCopyable &operator=(const NonCopyable &) = delete;
  // UWAGA: również nieprzenaszalna
};

class MyType : NonCopyable {};

struct MyTypeV2 {
  MyTypeV2() = default;
  MyTypeV2(const MyTypeV2 &) = delete;
  MyTypeV2 &operator=(const MyTypeV2 &) = delete;
  MyTypeV2(MyTypeV2 &&) = delete;
  MyTypeV2 &operator=(MyTypeV2 &&) = delete;
};

int main() {
  // W standardzie C++17 i wyższych pomimo niekopiowalności to działa z powodu obowiązkowego pomijania kopiowania.
  auto my_object = MyType{};
  auto my_better_object = MyTypeV2{};
}
