
#include <Wire.h>
#include "DS1631.h"


uint8_t _Temp[2];

DS1631::DS1631(uint8_t _ADDR)
{
  //Wire.begin(); // Zestawienie poczenia i2c
  //  stopConversion( _ADDR);

  // Wczenie cigej konwersji
  // startConversion( _ADDR);
}

DS1631::~DS1631(){
}

void DS1631::begin()
{
}

void DS1631::stopConversion(uint8_t _ADDR)
{
  Wire.beginTransmission(_ADDR);
  Wire.write(0x22); // polecenie wyczenia konwersji
  Wire.endTransmission();
}

void DS1631::startConversion(uint8_t _ADDR)
{
  Wire.beginTransmission(_ADDR);
  Wire.write(0x51); // polecenie wczenia konwersji
  Wire.endTransmission();
}

byte DS1631::getConfig(uint8_t _ADDR)
{
  byte config;

  stopConversion(_ADDR);
  Wire.beginTransmission(_ADDR);
  Wire.write(0xAC); // polecenie odczytu konfiguracji
  Wire.endTransmission();
  Wire.requestFrom(_addr, (uint8_t) 0x01); // konfiguracja zajmuje jeden bajt
  while (Wire.available())
  {
    config = Wire.read();
  }

  Wire.endTransmission();
  startConversion(_ADDR);
  return config;
}

void DS1631::setConfig(uint8_t _ADDR, uint8_t config) // opcje konfiguracyjne
{
  stopConversion(_ADDR);
  Wire.beginTransmission(_ADDR);
  Wire.write(0xAC);   // polecenie odczytu konfiguracji
  Wire.write(config); // konfiguracja z opcjami
  Wire.endTransmission();
  startConversion(_ADDR);
}

float DS1631::getTemp(uint8_t _ADDR) // polecenie 0xAA odczytu temperatury, odczyt 2 bajtw, pomiar pojedynczy
{
  unsigned char _Temp[2];
  int count = 0;

  Wire.beginTransmission(_ADDR);
  Wire.write(0xAA); // pocztek odczytu temperatury
  Wire.endTransmission();
  Wire.requestFrom(_ADDR,  (uint8_t)2); // odczyt 2-bajtowej wartoci

  while(Wire.available())
  {
    _Temp[count] = Wire.read();
    count++;
  }


  Serial.print("Th: ");
  Serial.print(_Temp[0]);
  Serial.print(" Tl: ");
  Serial.println(_Temp[1]);
  float temp = getTwosCompliment(_Temp[0],_Temp[1]);
  return temp;
}

float DS1631::getTwosCompliment(int Th,  int Tl)
{
  float num = 0.0;
 // dopuszczalne, ale tylko 2-3 znaczce bity
 //float  altnum = ((((short)Th<<8) | (short)Tl)>>6) / 4.0;  
   
  Tl = Tl >> 4; // wysunicie ostatnich 4 bitw, poniewa s rwnie 0
  if (Th & 0x80) // sprawdzenie, czy bit znaku = 1, utworzenie liczby ujemnej;
  {
    Th = Th - 256;
  }
  // konwersja zmiennoprzecinkowa
  num = (float) (Th + Tl*0.0625);
 
  return  num;
}




