#include <Wire.h>
#include "DS1631.h"

// Adresy pinów ustawione na GND
uint8_t DS1631_ADDR = 0x90; // 0x90 >> 1
char temperature[6] = {'00.000'};

// Konfiguracja
void setup(){
    
  // Konfiguracja połączenia szeregowego
  Serial.begin(9600);
  Serial.println("");
  Serial.println("-----------------------------------");
  Serial.println("Test DS1631: czujnik temperatury");
  Serial.println("-----------------------------------");
  Serial.println("");
  
  setUpDS1631() ;
 
}

// Główna pętla
void loop(){
  
  getTemp(temperature);

}

void setUpDS1631() 
{
  Wire.begin();             // dołączenie do szyny I2C

  // Wyłączenie konwersji, aby można było zmodyfikować rejestr "Access Config"
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write((int)(0x22)); // Wyłączenie konwersji
  Wire.endTransmission();  
    
  // Odczyt rejestru "Access Config"
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write((int)(0xAC)); // @AC : konfiguracja dostępu
  Wire.endTransmission();
  Wire.requestFrom(DS1631_ADDR,(uint8_t)1); // Odczyt 1 bajtu
  Wire.available();
  int AC = Wire.read(); // odebranie bajtu

  Serial.print("Rejestr Acces Config (przed): "); Serial.print(AC);  Serial.println("");
    
  // Zapis do rejestru "Access Config"
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write(0xAC); // @AC : konfiguracja dostępu
  Wire.write(0x0C); // ciągła konwersja z 12-bitową dokładnością
  Wire.endTransmission();
    
  // Odczyt rejestru "Access Config"
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write((int)(0xAC)); // @AC : konfiguracja dostępu
  Wire.endTransmission();
  Wire.requestFrom(DS1631_ADDR,(uint8_t)1);
  Wire.available();
  AC = Wire.read();

  Serial.print("Rejestr Acces Acces Config (PO): "); Serial.print(AC);  Serial.println("");
  
  // Włączenie konwersji i odczyt temperatury
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write((int)(0x51)); // włączenie konwersji
  Wire.endTransmission(); 
}

void getTemp(char *temp)
{
  
   // Odczyt temperatury
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write((int)(0xAA)); // @AA : Temperatura
  Wire.endTransmission();
  Wire.requestFrom(DS1631_ADDR,(uint8_t) 2); // odczyt 2 bajtów
  Wire.available(); // pierwszy bajt
  int Th = Wire.read(); // odbiór bajtu
  Wire.available(); // drugi bajt
  int Tl = Wire.read(); // odbiór bajtu


  // Przetwarzanie temperatury
  if(Th>=0x80) // jeżeli bit znaku jest ustawiony, temperatura jest ujemna
  Th = Th - 256;
  int T_dec=(10*(100*(Tl/16)))/16; // część dziesiętna temperatury

  // Wyświetlenie temperatury na montiorze portu szeregowego
  Serial.print("Temperatura : ");
  Serial.print(Th);   Serial.print(".");
  if (T_dec<10)   Serial.print("0");
  if (T_dec<100)   Serial.print("0");
  Serial.print(T_dec);   Serial.print(" st. C / ");
  Serial.print("Rejestr Th: "); Serial.print(Th);  Serial.print(" / ");
  Serial.print("Rejestr Tl: "); Serial.print(Tl);  Serial.println("");
  
  // Odczekaj 1 s przed restartem
  delay(1000); 
}

