
#include <Wire.h>
#include "DS1631.h"



DS1631::DS1631(uint8_t DS1631_ADDR)
{
  Wire.begin(); // Zestawienie poczenia i2c
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write(0x22); // Polecenie 0x22 wyczenia konwersji
  Wire.endTransmission();

  // Rozpoczcie cigek konwersji

}

DS1631::~DS1631(){
}

void DS1631::begin()
{
}

uint8_t getConfig(uint8_t DS1631_ADDR)
{
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write(0xAC); // polecenie odczytu konfiguracji
  Wire.endTransmission();
  Wire.requestFrom(DS1631_ADDR, (uint8_t) 1); // konfiguracja zajmuje jeden bajt
  Wire.available();
  uint8_t config = Wire.read();
  Wire.endTransmission();
  return config;
}

void setConfig(uint8_t DS1631_ADDR, uint8_t config) // opcje konfiguracyjne
{
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write(0xAC); // polecenie odczytu konfiguracji
  Wire.write(config); // konfiguracja z opcjami
  Wire.endTransmission();
}

float DS1631::getTemp(uint8_t DS1631_ADDR) // polecenie 0xAA odczytu temperatury, odczyt 2 bajtw, pomiar pojedynczy
{
  Wire.beginTransmission(DS1631_ADDR);
  Wire.write(0xAA); // pocztek odczytu temperatury
  Wire.endTransmission();
  Wire.requestFrom(DS1631_ADDR, (uint8_t) 2); // odczyt 2-bajtowej wartoci
  Wire.available();
  uint8_t Th = Wire.read(); // starszy bajt
  Wire.available();
  uint8_t Tl = Wire.read(); // modszy bajt
  float temp = getTwosCompliment(Th,Tl);
  return temp;
}
/*
void DS1631::printTemp()
{
}
char* DS1631::getStrTemp()
{
  return "sad";
}
*/


float getTwosCompliment(uint8_t Th, uint8_t Tl)
{
  float num;
  // Znak jest rwny 0x80
  if(Th >= 0x80)
  {
    num = (float) ((Th<<8 + Th) - 65536)*0.0625;
  }
  else
  {
    num = (float)(Th<<8 + Tl)*0.0625;
  }
  return num;
}

