// Listing 10.2. Szkic kodu dla urzdzenia slave
byte dataToEcho; // deklaracja zmiennych globalnych wykorzystywanych przez przerwanie
boolean blink = LOW;
void setup() {
  Serial.begin(115200);
  DDRB |= 0b00010001;    // wyjcie MISO LED(8)
  PORTB |= 0b00000100;   // stan wysoki na linii wyboru urzdzenia slave
  SPCR |= 0b11000000;    // ustawienie bitw SPIE i SPE
  SPSR |= 0b00000000;    // domylne ustawienia SPI
  sei(); // globalne wczenie przerwa
} // koniec setup

void loop() {
  digitalWrite(8, (blink = !blink));   // miganie diody oznaczajce prac
  delay(1000);  
} // koniec loop

ISR(SPI_STC_vect) {
  cli(); // wyczenie przerwa na czas wykonywania krytycznego kodu
  while (!(PINB & 0b00000100)) { // wejcie do ptli, jeeli linia slave select ma stan niski
    SPDR = dataToEcho; // wpisanie do rejestru SPI danych do przesunicia
    while (!(SPSR & (1 << SPIF))); // oczekiwanie na zakoczenie transmisji
    dataToEcho = SPDR; // odczyt danych przychodzcych; bajt bdzie wysany przy nastpnym przerwaniu
  }
  sei(); // wczenie przerwa z powrotem po zakoczeniu
} // koniec procedury ISR
