/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class RangeBarChart
extends BarChart {
    public static final String TYPE = "RangeBar";

    RangeBarChart() {
    }

    public RangeBarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, BarChart.Type type) {
        super(dataset, renderer, type);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        int length = points.length;
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float halfDiffX = this.getHalfDiffX(points, length, seriesNr);
        int start = 0;
        if (startIndex > 0) {
            start = 2;
        }
        for (int i = start; i < length; i += 4) {
            if (points.length <= i + 3) continue;
            float xMin = points[i];
            float yMin = points[i + 1];
            float xMax = points[i + 2];
            float yMax = points[i + 3];
            this.drawBar(canvas, xMin, yMin, xMax, yMax, halfDiffX, seriesNr, seriesIndex, paint);
        }
        paint.setColor(seriesRenderer.getColor());
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries series, SimpleSeriesRenderer renderer, Paint paint, float[] points, int seriesIndex, int startIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        float halfDiffX = this.getHalfDiffX(points, points.length, seriesNr);
        int start = 0;
        if (startIndex > 0) {
            start = 2;
        }
        for (int i = start; i < points.length; i += 4) {
            int index = startIndex + i / 2;
            float x = points[i];
            if (this.mType == BarChart.Type.DEFAULT) {
                x += (float)(seriesIndex * 2) * halfDiffX - ((float)seriesNr - 1.5f) * halfDiffX;
            }
            if (!this.isNullValue(series.getY(index + 1)) && points.length > i + 3) {
                this.drawText(canvas, this.getLabel(series.getY(index + 1)), x, points[i + 3] - renderer.getChartValuesSpacing(), paint, 0.0f);
            }
            if (this.isNullValue(series.getY(index)) || points.length <= i + 1) continue;
            this.drawText(canvas, this.getLabel(series.getY(index)), x, points[i + 1] + renderer.getChartValuesTextSize() + renderer.getChartValuesSpacing() - 3.0f, paint, 0.0f);
        }
    }

    @Override
    protected float getCoeficient() {
        return 0.5f;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

