/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.achartengine.util.XYEntry;

public class IndexXYMap<K, V>
extends TreeMap<K, V> {
    private final List<K> indexList = new ArrayList<K>();
    private double maxXDifference = 0.0;

    @Override
    public V put(K key, V value) {
        this.indexList.add(key);
        this.updateMaxXDifference();
        return super.put(key, value);
    }

    private void updateMaxXDifference() {
        if (this.indexList.size() < 2) {
            this.maxXDifference = 0.0;
            return;
        }
        if (Math.abs((Double)this.indexList.get(this.indexList.size() - 1) - (Double)this.indexList.get(this.indexList.size() - 2)) > this.maxXDifference) {
            this.maxXDifference = Math.abs((Double)this.indexList.get(this.indexList.size() - 1) - (Double)this.indexList.get(this.indexList.size() - 2));
        }
    }

    public double getMaxXDifference() {
        return this.maxXDifference;
    }

    @Override
    public void clear() {
        this.updateMaxXDifference();
        super.clear();
        this.indexList.clear();
    }

    public K getXByIndex(int index) {
        return this.indexList.get(index);
    }

    public V getYByIndex(int index) {
        K key = this.indexList.get(index);
        return this.get(key);
    }

    public XYEntry<K, V> getByIndex(int index) {
        K key = this.indexList.get(index);
        return new XYEntry(key, this.get(key));
    }

    public XYEntry<K, V> removeByIndex(int index) {
        K key = this.indexList.remove(index);
        return new XYEntry(key, this.remove(key));
    }

    public int getIndexForKey(K key) {
        return Collections.binarySearch(this.indexList, key, null);
    }
}

