/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.graphics.RectF;
import android.view.MotionEvent;
import org.achartengine.GraphicalView;
import org.achartengine.ITouchHandler;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.Pan;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.Zoom;
import org.achartengine.tools.ZoomListener;

public class TouchHandler
implements ITouchHandler {
    private DefaultRenderer mRenderer;
    private float oldX;
    private float oldY;
    private float oldX2;
    private float oldY2;
    private RectF zoomR = new RectF();
    private Pan mPan;
    private Zoom mPinchZoom;
    private GraphicalView graphicalView;

    public TouchHandler(GraphicalView view, AbstractChart chart) {
        this.graphicalView = view;
        this.zoomR = this.graphicalView.getZoomRectangle();
        this.mRenderer = chart instanceof XYChart ? ((XYChart)chart).getRenderer() : ((RoundChart)chart).getRenderer();
        if (this.mRenderer.isPanEnabled()) {
            this.mPan = new Pan(chart);
        }
        if (this.mRenderer.isZoomEnabled()) {
            this.mPinchZoom = new Zoom(chart, true, 1.0f);
        }
    }

    @Override
    public boolean handleTouch(MotionEvent event) {
        int action = event.getAction();
        if (this.mRenderer != null && action == 2) {
            if (this.oldX >= 0.0f || this.oldY >= 0.0f) {
                float newX = event.getX(0);
                float newY = event.getY(0);
                if (event.getPointerCount() > 1 && (this.oldX2 >= 0.0f || this.oldY2 >= 0.0f) && this.mRenderer.isZoomEnabled()) {
                    float newX2 = event.getX(1);
                    float newY2 = event.getY(1);
                    float newDeltaX = Math.abs(newX - newX2);
                    float newDeltaY = Math.abs(newY - newY2);
                    float oldDeltaX = Math.abs(this.oldX - this.oldX2);
                    float oldDeltaY = Math.abs(this.oldY - this.oldY2);
                    float zoomRate = 1.0f;
                    float tan1 = Math.abs(newY - this.oldY) / Math.abs(newX - this.oldX);
                    float tan2 = Math.abs(newY2 - this.oldY2) / Math.abs(newX2 - this.oldX2);
                    if ((double)tan1 <= 0.577 && (double)tan2 <= 0.577) {
                        zoomRate = newDeltaX / oldDeltaX;
                        if ((double)zoomRate > 0.909 && (double)zoomRate < 1.1) {
                            this.mPinchZoom.setZoomRate(zoomRate);
                            this.mPinchZoom.apply(1);
                        }
                    } else if ((double)tan1 >= 1.732 && (double)tan2 >= 1.732) {
                        zoomRate = newDeltaY / oldDeltaY;
                        if ((double)zoomRate > 0.909 && (double)zoomRate < 1.1) {
                            this.mPinchZoom.setZoomRate(zoomRate);
                            this.mPinchZoom.apply(2);
                        }
                    } else if ((double)tan1 > 0.577 && (double)tan1 < 1.732 && (double)tan2 > 0.577 && (double)tan2 < 1.732 && (double)(zoomRate = Math.abs(newX - this.oldX) >= Math.abs(newY - this.oldY) ? newDeltaX / oldDeltaX : newDeltaY / oldDeltaY) > 0.909 && (double)zoomRate < 1.1) {
                        this.mPinchZoom.setZoomRate(zoomRate);
                        this.mPinchZoom.apply(0);
                    }
                    this.oldX2 = newX2;
                    this.oldY2 = newY2;
                } else if (this.mRenderer.isPanEnabled()) {
                    this.mPan.apply(this.oldX, this.oldY, newX, newY);
                    this.oldX2 = 0.0f;
                    this.oldY2 = 0.0f;
                }
                this.oldX = newX;
                this.oldY = newY;
                this.graphicalView.repaint();
                return true;
            }
        } else if (action == 0) {
            this.oldX = event.getX(0);
            this.oldY = event.getY(0);
            if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && this.zoomR.contains(this.oldX, this.oldY)) {
                if (this.oldX < this.zoomR.left + this.zoomR.width() / 3.0f) {
                    this.graphicalView.zoomIn();
                } else if (this.oldX < this.zoomR.left + this.zoomR.width() * 2.0f / 3.0f) {
                    this.graphicalView.zoomOut();
                } else {
                    this.graphicalView.zoomReset();
                }
                return true;
            }
        } else if (action == 1 || action == 6) {
            this.oldX = 0.0f;
            this.oldY = 0.0f;
            this.oldX2 = 0.0f;
            this.oldY2 = 0.0f;
            if (action == 6) {
                this.oldX = -1.0f;
                this.oldY = -1.0f;
            }
        }
        return !this.mRenderer.isClickEnabled();
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.addZoomListener(listener);
        }
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.removeZoomListener(listener);
        }
    }

    @Override
    public void addPanListener(PanListener listener) {
        if (this.mPan != null) {
            this.mPan.addPanListener(listener);
        }
    }

    @Override
    public void removePanListener(PanListener listener) {
        if (this.mPan != null) {
            this.mPan.removePanListener(listener);
        }
    }
}

