/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.BasicStroke;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private Point mCenter;
    private Rect mScreenR;
    private final Map<Integer, double[]> mCalcRange = new HashMap<Integer, double[]>();
    private Map<Integer, List<ClickableArea>> clickableAreas = new HashMap<Integer, List<ClickableArea>>();

    protected XYChart() {
    }

    public XYChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    @Override
    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        int i;
        int angle;
        XYMultipleSeriesRenderer.Orientation or;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, this.mRenderer.getAxisTitleTextSize());
        int[] margins = this.mRenderer.getMargins();
        int left = x + margins[1];
        int top = y + margins[0];
        int right = x + width - margins[3];
        int sLength = this.mDataset.getSeriesCount();
        String[] titles = new String[sLength];
        for (int i2 = 0; i2 < sLength; ++i2) {
            titles[i2] = this.mDataset.getSeriesAt(i2).getTitle();
        }
        if (this.mRenderer.isFitLegend() && this.mRenderer.isShowLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - margins[2] - legendSize;
        if (this.mScreenR == null) {
            this.mScreenR = new Rect();
        }
        this.mScreenR.set(left, top, right, bottom);
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        if (paint.getTypeface() == null || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
        }
        if ((or = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            right -= legendSize;
            bottom += legendSize - 20;
        }
        boolean rotate = (angle = or.getAngle()) == 90;
        this.mScale = (float)height / (float)width;
        this.mTranslate = Math.abs(width - height) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new Point((x + width) / 2, (y + height) / 2);
        if (rotate) {
            this.transform(canvas, angle, false);
        }
        int maxScaleNumber = -2147483647;
        for (int i3 = 0; i3 < sLength; ++i3) {
            maxScaleNumber = Math.max(maxScaleNumber, this.mDataset.getSeriesAt(i3).getScaleNumber());
        }
        if (++maxScaleNumber < 0) {
            return;
        }
        double[] minX = new double[maxScaleNumber];
        double[] maxX = new double[maxScaleNumber];
        double[] minY = new double[maxScaleNumber];
        double[] maxY = new double[maxScaleNumber];
        boolean[] isMinXSet = new boolean[maxScaleNumber];
        boolean[] isMaxXSet = new boolean[maxScaleNumber];
        boolean[] isMinYSet = new boolean[maxScaleNumber];
        boolean[] isMaxYSet = new boolean[maxScaleNumber];
        for (int i4 = 0; i4 < maxScaleNumber; ++i4) {
            minX[i4] = this.mRenderer.getXAxisMin(i4);
            maxX[i4] = this.mRenderer.getXAxisMax(i4);
            minY[i4] = this.mRenderer.getYAxisMin(i4);
            maxY[i4] = this.mRenderer.getYAxisMax(i4);
            isMinXSet[i4] = this.mRenderer.isMinXSet(i4);
            isMaxXSet[i4] = this.mRenderer.isMaxXSet(i4);
            isMinYSet[i4] = this.mRenderer.isMinYSet(i4);
            isMaxYSet[i4] = this.mRenderer.isMaxYSet(i4);
            if (this.mCalcRange.get(i4) != null) continue;
            this.mCalcRange.put(i4, new double[4]);
        }
        double[] xPixelsPerUnit = new double[maxScaleNumber];
        double[] yPixelsPerUnit = new double[maxScaleNumber];
        for (i = 0; i < sLength; ++i) {
            XYSeries series = this.mDataset.getSeriesAt(i);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            if (!isMinXSet[scale]) {
                double minimumX = series.getMinX();
                minX[scale] = Math.min(minX[scale], minimumX);
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[0] = minX[scale];
            }
            if (!isMaxXSet[scale]) {
                double maximumX = series.getMaxX();
                maxX[scale] = Math.max(maxX[scale], maximumX);
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[1] = maxX[scale];
            }
            if (!isMinYSet[scale]) {
                double minimumY = series.getMinY();
                minY[scale] = Math.min(minY[scale], (double)((float)minimumY));
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[2] = minY[scale];
            }
            if (isMaxYSet[scale]) continue;
            double maximumY = series.getMaxY();
            maxY[scale] = Math.max(maxY[scale], (double)((float)maximumY));
            this.mCalcRange.get((Object)Integer.valueOf((int)scale))[3] = maxY[scale];
        }
        for (i = 0; i < maxScaleNumber; ++i) {
            if (maxX[i] - minX[i] != 0.0) {
                xPixelsPerUnit[i] = (double)(right - left) / (maxX[i] - minX[i]);
            }
            if (maxY[i] - minY[i] == 0.0) continue;
            yPixelsPerUnit[i] = (float)((double)(bottom - top) / (maxY[i] - minY[i]));
        }
        boolean hasValues = false;
        this.clickableAreas = new HashMap<Integer, List<ClickableArea>>();
        for (int i5 = 0; i5 < sLength; ++i5) {
            XYSeries series = this.mDataset.getSeriesAt(i5);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            hasValues = true;
            SimpleSeriesRenderer seriesRenderer = this.mRenderer.getSeriesRendererAt(i5);
            ArrayList<Float> points = new ArrayList<Float>();
            ArrayList<Double> values = new ArrayList<Double>();
            float yAxisValue = Math.min((float)bottom, (float)((double)bottom + yPixelsPerUnit[scale] * minY[scale]));
            LinkedList<ClickableArea> clickableArea = new LinkedList<ClickableArea>();
            this.clickableAreas.put(i5, clickableArea);
            SortedMap<Double, Double> range = series.getRange(minX[scale], maxX[scale], 1);
            int startIndex = -1;
            for (Map.Entry<Double, Double> value : range.entrySet()) {
                double xValue = value.getKey();
                double yValue = value.getValue();
                if (startIndex < 0) {
                    startIndex = series.getIndexForKey(xValue);
                }
                values.add(value.getKey());
                values.add(value.getValue());
                if (!this.isNullValue(yValue)) {
                    points.add(Float.valueOf((float)((double)left + xPixelsPerUnit[scale] * (xValue - minX[scale]))));
                    points.add(Float.valueOf((float)((double)bottom - yPixelsPerUnit[scale] * (yValue - minY[scale]))));
                    continue;
                }
                if (this.isRenderNullValues()) {
                    points.add(Float.valueOf((float)((double)left + xPixelsPerUnit[scale] * (xValue - minX[scale]))));
                    points.add(Float.valueOf((float)((double)bottom - yPixelsPerUnit[scale] * -minY[scale])));
                    continue;
                }
                if (points.size() > 0) {
                    this.drawSeries(series, canvas, paint, points, seriesRenderer, yAxisValue, i5, or, startIndex);
                    ClickableArea[] clickableAreasForSubSeries = this.clickableAreasForPoints(MathHelper.getFloats(points), MathHelper.getDoubles(values), yAxisValue, i5, startIndex);
                    clickableArea.addAll(Arrays.asList(clickableAreasForSubSeries));
                    points.clear();
                    values.clear();
                }
                clickableArea.add(null);
            }
            if (points.size() <= 0) continue;
            this.drawSeries(series, canvas, paint, points, seriesRenderer, yAxisValue, i5, or, startIndex);
            ClickableArea[] clickableAreasForSubSeries = this.clickableAreasForPoints(MathHelper.getFloats(points), MathHelper.getDoubles(values), yAxisValue, i5, startIndex);
            clickableArea.addAll(Arrays.asList(clickableAreasForSubSeries));
        }
        this.drawBackground(this.mRenderer, canvas, x, bottom, width, height - bottom, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, x, y, width, margins[0], paint, true, this.mRenderer.getMarginsColor());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, right, y, margins[3], height - y, paint, true, this.mRenderer.getMarginsColor());
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, right, y, width - right, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
        }
        boolean showLabels = this.mRenderer.isShowLabels() && hasValues;
        boolean showGridX = this.mRenderer.isShowGridX();
        boolean showCustomTextGrid = this.mRenderer.isShowCustomTextGrid();
        if (showLabels || showGridX) {
            List<Double> xLabels = this.getValidLabels(this.getXLabels(minX[0], maxX[0], this.mRenderer.getXLabels()));
            Map<Integer, List<Double>> allYLabels = this.getYLabels(minY, maxY, maxScaleNumber);
            int xLabelsLeft = left;
            if (showLabels) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
                if (this.mRenderer.getXLabelsAlign() == Paint.Align.LEFT) {
                    xLabelsLeft = (int)((float)xLabelsLeft + this.mRenderer.getLabelsTextSize() / 4.0f);
                }
            }
            this.drawXLabels(xLabels, this.mRenderer.getXTextLabelLocations(), canvas, paint, xLabelsLeft, top, bottom, xPixelsPerUnit[0], minX[0], maxX[0]);
            this.drawYLabels(allYLabels, canvas, paint, maxScaleNumber, left, right, bottom, yPixelsPerUnit, minY);
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                for (int i6 = 0; i6 < maxScaleNumber; ++i6) {
                    Double[] yTextLabelLocations;
                    Paint.Align axisAlign = this.mRenderer.getYAxisAlign(i6);
                    for (Double location : yTextLabelLocations = this.mRenderer.getYTextLabelLocations(i6)) {
                        if (!(minY[i6] <= location) || !(location <= maxY[i6])) continue;
                        float yLabel = (float)((double)bottom - yPixelsPerUnit[i6] * (location - minY[i6]));
                        String label = this.mRenderer.getYTextLabel(location, i6);
                        paint.setColor(this.mRenderer.getYLabelsColor(i6));
                        paint.setTextAlign(this.mRenderer.getYLabelsAlign(i6));
                        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                            if (axisAlign == Paint.Align.LEFT) {
                                canvas.drawLine((float)(left + this.getLabelLinePos(axisAlign)), yLabel, (float)left, yLabel, paint);
                                this.drawText(canvas, label, left, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                canvas.drawLine((float)right, yLabel, (float)(right + this.getLabelLinePos(axisAlign)), yLabel, paint);
                                this.drawText(canvas, label, right, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            }
                            if (!showCustomTextGrid) continue;
                            paint.setColor(this.mRenderer.getGridColor());
                            canvas.drawLine((float)left, yLabel, (float)right, yLabel, paint);
                            continue;
                        }
                        canvas.drawLine((float)(right - this.getLabelLinePos(axisAlign)), yLabel, (float)right, yLabel, paint);
                        this.drawText(canvas, label, right + 10, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                        if (!showCustomTextGrid) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawLine((float)right, yLabel, (float)left, yLabel, paint);
                    }
                }
            }
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                float size = this.mRenderer.getAxisTitleTextSize();
                paint.setTextSize(size);
                paint.setTextAlign(Paint.Align.CENTER);
                if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), x + width / 2, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + size, paint, 0.0f);
                    for (int i7 = 0; i7 < maxScaleNumber; ++i7) {
                        Paint.Align axisAlign = this.mRenderer.getYAxisAlign(i7);
                        if (axisAlign == Paint.Align.LEFT) {
                            this.drawText(canvas, this.mRenderer.getYTitle(i7), (float)x + size, y + height / 2, paint, -90.0f);
                            continue;
                        }
                        this.drawText(canvas, this.mRenderer.getYTitle(i7), x + width, y + height / 2, paint, -90.0f);
                    }
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), x + width / 2, (float)y + this.mRenderer.getChartTitleTextSize(), paint, 0.0f);
                } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), x + width / 2, (float)(y + height) - size, paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), right + 20, y + height / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), (float)x + size, top + height / 2, paint, 0.0f);
                }
            }
        }
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, angle, true);
            this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
            this.transform(canvas, angle, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            canvas.drawLine((float)left, (float)bottom, (float)right, (float)bottom, paint);
            boolean rightAxis = false;
            for (int i8 = 0; i8 < maxScaleNumber && !rightAxis; ++i8) {
                rightAxis = this.mRenderer.getYAxisAlign(i8) == Paint.Align.RIGHT;
            }
            if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine((float)left, (float)top, (float)left, (float)bottom, paint);
                if (rightAxis) {
                    canvas.drawLine((float)right, (float)top, (float)right, (float)bottom, paint);
                }
            } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine((float)right, (float)top, (float)right, (float)bottom, paint);
            }
        }
        if (rotate) {
            this.transform(canvas, angle, true);
        }
    }

    protected List<Double> getXLabels(double min, double max, int count) {
        return MathHelper.getLabels(min, max, count);
    }

    protected Map<Integer, List<Double>> getYLabels(double[] minY, double[] maxY, int maxScaleNumber) {
        HashMap<Integer, List<Double>> allYLabels = new HashMap<Integer, List<Double>>();
        for (int i = 0; i < maxScaleNumber; ++i) {
            allYLabels.put(i, this.getValidLabels(MathHelper.getLabels(minY[i], maxY[i], this.mRenderer.getYLabels())));
        }
        return allYLabels;
    }

    protected Rect getScreenR() {
        return this.mScreenR;
    }

    protected void setScreenR(Rect screenR) {
        this.mScreenR = screenR;
    }

    private List<Double> getValidLabels(List<Double> labels) {
        ArrayList<Double> result = new ArrayList<Double>(labels);
        for (Double label : labels) {
            if (!label.isNaN()) continue;
            result.remove(label);
        }
        return result;
    }

    protected void drawSeries(XYSeries series, Canvas canvas, Paint paint, List<Float> pointsList, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, XYMultipleSeriesRenderer.Orientation or, int startIndex) {
        ScatterChart pointsChart;
        BasicStroke stroke = seriesRenderer.getStroke();
        Paint.Cap cap = paint.getStrokeCap();
        Paint.Join join = paint.getStrokeJoin();
        float miter = paint.getStrokeMiter();
        PathEffect pathEffect = paint.getPathEffect();
        Paint.Style style = paint.getStyle();
        if (stroke != null) {
            DashPathEffect effect = null;
            if (stroke.getIntervals() != null) {
                effect = new DashPathEffect(stroke.getIntervals(), stroke.getPhase());
            }
            this.setStroke(stroke.getCap(), stroke.getJoin(), stroke.getMiter(), Paint.Style.FILL_AND_STROKE, (PathEffect)effect, paint);
        }
        float[] points = MathHelper.getFloats(pointsList);
        this.drawSeries(canvas, paint, points, seriesRenderer, yAxisValue, seriesIndex, startIndex);
        if (this.isRenderPoints(seriesRenderer) && (pointsChart = this.getPointsChart()) != null) {
            pointsChart.drawSeries(canvas, paint, points, seriesRenderer, yAxisValue, seriesIndex, startIndex);
        }
        paint.setTextSize(seriesRenderer.getChartValuesTextSize());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(Paint.Align.CENTER);
        } else {
            paint.setTextAlign(Paint.Align.LEFT);
        }
        if (seriesRenderer.isDisplayChartValues()) {
            paint.setTextAlign(seriesRenderer.getChartValuesTextAlign());
            this.drawChartValuesText(canvas, series, seriesRenderer, paint, points, seriesIndex, startIndex);
        }
        if (stroke != null) {
            this.setStroke(cap, join, miter, style, pathEffect, paint);
        }
    }

    private void setStroke(Paint.Cap cap, Paint.Join join, float miter, Paint.Style style, PathEffect pathEffect, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(miter);
        paint.setPathEffect(pathEffect);
        paint.setStyle(style);
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries series, SimpleSeriesRenderer renderer, Paint paint, float[] points, int seriesIndex, int startIndex) {
        if (points.length > 1) {
            float previousPointX = points[0];
            float previousPointY = points[1];
            for (int k = 0; k < points.length; k += 2) {
                if (k == 2) {
                    if (!(Math.abs(points[2] - points[0]) > 100.0f) && !(Math.abs(points[3] - points[1]) > 100.0f)) continue;
                    this.drawText(canvas, this.getLabel(series.getY(startIndex)), points[0], points[1] - renderer.getChartValuesSpacing(), paint, 0.0f);
                    this.drawText(canvas, this.getLabel(series.getY(startIndex + 1)), points[2], points[3] - renderer.getChartValuesSpacing(), paint, 0.0f);
                    previousPointX = points[2];
                    previousPointY = points[3];
                    continue;
                }
                if (k <= 2 || !(Math.abs(points[k] - previousPointX) > 100.0f) && !(Math.abs(points[k + 1] - previousPointY) > 100.0f)) continue;
                this.drawText(canvas, this.getLabel(series.getY(startIndex + k / 2)), points[k], points[k + 1] - renderer.getChartValuesSpacing(), paint, 0.0f);
                previousPointX = points[k];
                previousPointY = points[k + 1];
            }
        } else {
            for (int k = 0; k < points.length; k += 2) {
                this.drawText(canvas, this.getLabel(series.getY(startIndex + k / 2)), points[k], points[k + 1] - renderer.getChartValuesSpacing(), paint, 0.0f);
            }
        }
    }

    protected void drawText(Canvas canvas, String text, float x, float y, Paint paint, float extraAngle) {
        float angle = (float)(-this.mRenderer.getOrientation().getAngle()) + extraAngle;
        if (angle != 0.0f) {
            canvas.rotate(angle, x, y);
        }
        this.drawString(canvas, text, x, y, paint);
        if (angle != 0.0f) {
            canvas.rotate(-angle, x, y);
        }
    }

    private void transform(Canvas canvas, float angle, boolean inverse) {
        if (inverse) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-angle, this.mCenter.getX(), this.mCenter.getY());
        } else {
            canvas.rotate(angle, this.mCenter.getX(), this.mCenter.getY());
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected String getLabel(double label) {
        String text = "";
        text = label == (double)Math.round(label) ? Math.round(label) + "" : label + "";
        return text;
    }

    protected void drawXLabels(List<Double> xLabels, Double[] xTextLabelLocations, Canvas canvas, Paint paint, int left, int top, int bottom, double xPixelsPerUnit, double minX, double maxX) {
        int length = xLabels.size();
        boolean showLabels = this.mRenderer.isShowLabels();
        boolean showGridY = this.mRenderer.isShowGridY();
        for (int i = 0; i < length; ++i) {
            double label = xLabels.get(i);
            float xLabel = (float)((double)left + xPixelsPerUnit * (label - minX));
            if (showLabels) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                canvas.drawLine(xLabel, (float)bottom, xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.getLabel(label), xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
            }
            if (!showGridY) continue;
            paint.setColor(this.mRenderer.getGridColor());
            canvas.drawLine(xLabel, (float)bottom, xLabel, (float)top, paint);
        }
        this.drawXTextLabels(xTextLabelLocations, canvas, paint, showLabels, left, top, bottom, xPixelsPerUnit, minX, maxX);
    }

    protected void drawYLabels(Map<Integer, List<Double>> allYLabels, Canvas canvas, Paint paint, int maxScaleNumber, int left, int right, int bottom, double[] yPixelsPerUnit, double[] minY) {
        XYMultipleSeriesRenderer.Orientation or = this.mRenderer.getOrientation();
        boolean showGridX = this.mRenderer.isShowGridX();
        boolean showLabels = this.mRenderer.isShowLabels();
        for (int i = 0; i < maxScaleNumber; ++i) {
            paint.setTextAlign(this.mRenderer.getYLabelsAlign(i));
            List<Double> yLabels = allYLabels.get(i);
            int length = yLabels.size();
            for (int j = 0; j < length; ++j) {
                double label = yLabels.get(j);
                Paint.Align axisAlign = this.mRenderer.getYAxisAlign(i);
                boolean textLabel = this.mRenderer.getYTextLabel(label, i) != null;
                float yLabel = (float)((double)bottom - yPixelsPerUnit[i] * (label - minY[i]));
                if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (showLabels && !textLabel) {
                        paint.setColor(this.mRenderer.getYLabelsColor(i));
                        if (axisAlign == Paint.Align.LEFT) {
                            canvas.drawLine((float)(left + this.getLabelLinePos(axisAlign)), yLabel, (float)left, yLabel, paint);
                            this.drawText(canvas, this.getLabel(label), left, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                        } else {
                            canvas.drawLine((float)right, yLabel, (float)(right + this.getLabelLinePos(axisAlign)), yLabel, paint);
                            this.drawText(canvas, this.getLabel(label), right, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                        }
                    }
                    if (!showGridX) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawLine((float)left, yLabel, (float)right, yLabel, paint);
                    continue;
                }
                if (or != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                if (showLabels && !textLabel) {
                    paint.setColor(this.mRenderer.getYLabelsColor(i));
                    canvas.drawLine((float)(right - this.getLabelLinePos(axisAlign)), yLabel, (float)right, yLabel, paint);
                    this.drawText(canvas, this.getLabel(label), right + 10, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                }
                if (!showGridX) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine((float)right, yLabel, (float)left, yLabel, paint);
            }
        }
    }

    protected void drawXTextLabels(Double[] xTextLabelLocations, Canvas canvas, Paint paint, boolean showLabels, int left, int top, int bottom, double xPixelsPerUnit, double minX, double maxX) {
        boolean showCustomTextGrid = this.mRenderer.isShowCustomTextGrid();
        if (showLabels) {
            paint.setColor(this.mRenderer.getXLabelsColor());
            for (Double location : xTextLabelLocations) {
                if (!(minX <= location) || !(location <= maxX)) continue;
                float xLabel = (float)((double)left + xPixelsPerUnit * (location - minX));
                paint.setColor(this.mRenderer.getXLabelsColor());
                canvas.drawLine(xLabel, (float)bottom, xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.mRenderer.getXTextLabel(location), xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                if (!showCustomTextGrid) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine(xLabel, (float)bottom, xLabel, (float)top, paint);
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange(int scale) {
        return this.mCalcRange.get(scale);
    }

    public void setCalcRange(double[] range, int scale) {
        this.mCalcRange.put(scale, range);
    }

    public double[] toRealPoint(float screenX, float screenY) {
        return this.toRealPoint(screenX, screenY, 0);
    }

    public double[] toScreenPoint(double[] realPoint) {
        return this.toScreenPoint(realPoint, 0);
    }

    private int getLabelLinePos(Paint.Align align) {
        int pos = 4;
        if (align == Paint.Align.LEFT) {
            pos = -pos;
        }
        return pos;
    }

    public double[] toRealPoint(float screenX, float screenY, int scale) {
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        return new double[]{(double)(screenX - (float)this.mScreenR.left) * (realMaxX - realMinX) / (double)this.mScreenR.width() + realMinX, (double)((float)(this.mScreenR.top + this.mScreenR.height()) - screenY) * (realMaxY - realMinY) / (double)this.mScreenR.height() + realMinY};
    }

    public double[] toScreenPoint(double[] realPoint, int scale) {
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        if (!(this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxXSet(scale) && this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxYSet(scale))) {
            double[] calcRange = this.getCalcRange(scale);
            realMinX = calcRange[0];
            realMaxX = calcRange[1];
            realMinY = calcRange[2];
            realMaxY = calcRange[3];
        }
        return new double[]{(realPoint[0] - realMinX) * (double)this.mScreenR.width() / (realMaxX - realMinX) + (double)this.mScreenR.left, (realMaxY - realPoint[1]) * (double)this.mScreenR.height() / (realMaxY - realMinY) + (double)this.mScreenR.top};
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        if (this.clickableAreas != null) {
            for (int seriesIndex = this.clickableAreas.size() - 1; seriesIndex >= 0; --seriesIndex) {
                int pointIndex = 0;
                if (this.clickableAreas.get(seriesIndex) == null) continue;
                for (ClickableArea area : this.clickableAreas.get(seriesIndex)) {
                    RectF rectangle = area.getRect();
                    if (rectangle != null && rectangle.contains(screenPoint.getX(), screenPoint.getY())) {
                        return new SeriesSelection(seriesIndex, pointIndex, area.getX(), area.getY());
                    }
                    ++pointIndex;
                }
            }
        }
        return super.getSeriesAndPointForScreenCoordinate(screenPoint);
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6, int var7);

    protected abstract ClickableArea[] clickableAreasForPoints(float[] var1, double[] var2, float var3, int var4, int var5);

    protected boolean isRenderNullValues() {
        return false;
    }

    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return Double.MAX_VALUE;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public abstract String getChartType();
}

