// Projekt nr 59  budowa systemu kontroli czasu pracy na bazie technologii RFID

#include "Wire.h" // dla moduu RTC
#define DS3232_I2C_ADDRESS 0x68
#include "SD.h" // dla kart SD

#include <LiquidCrystal.h>
LiquidCrystal lcd( 8, 9, 4, 5, 6, 7 );
int data1 = 0;

// identyfikatory etykiet RFID mona sprawdzi za pomoc szkicu z listingu 16.1
int Mary[14] = {
   2, 52, 48, 48, 48, 56, 54, 67, 54, 54, 66, 54, 66, 3};
int John[14] = {
   2, 52, 48, 48, 48, 56, 54, 66, 49, 52, 70, 51, 56, 3};
int newtag[14] = {
   0,0,0,0,0,0,0,0,0,0,0,0,0,0}; // tablica uywana do porwnywania odczytanego identyfikatora

// Konwertuje liczby dziesitne na zakodowane wartoci binarne
byte decToBcd(byte val)
{
   return( (val/10*16) + (val%10) );
}

// Konwertuje zakodowane wartoci binarne na liczby dziesitne
byte bcdToDec(byte val)
{
   return( (val/16*10) + (val%16) );
}

void setDS3232time(byte second, byte minute, byte hour, byte dayOfWeek, byte
dayOfMonth, byte month, byte year)
{
   // ustawia dat i godzin w module DS3232
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // okrela, e nastpna warto ma trafi do rejestru sekund
   Wire.write(decToBcd(second));     // ustawia sekundy
   Wire.write(decToBcd(minute));     // ustawia minuty
   Wire.write(decToBcd(hour));       // ustawia godziny
   Wire.write(decToBcd(dayOfWeek));  // ustawia dzie tygodnia (1 = niedziela, 7 = sobota)
   Wire.write(decToBcd(dayOfMonth)); // ustawia dzie miesica (od 1 do 31)
   Wire.write(decToBcd(month));      // ustawia miesic
   Wire.write(decToBcd(year));       // ustawia rok (od 0 do 99)
   Wire.endTransmission();
}

void readDS3232time(byte *second,
byte *minute,
byte *hour,
byte *dayOfWeek,
byte *dayOfMonth,
byte *month,
byte *year)
{
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // ustawia wskanik rejestru DS3232 na pozycji 00h
   Wire.endTransmission();
   Wire.requestFrom(DS3232_I2C_ADDRESS, 7);

   // da siedmiu bajtw danych od moduu DS3232, poczwszy od rejestru 00h
   *second     = bcdToDec(Wire.read() & 0x7f);
   *minute     = bcdToDec(Wire.read());
   *hour       = bcdToDec(Wire.read() & 0x3f);
   *dayOfWeek  = bcdToDec(Wire.read());
   *dayOfMonth = bcdToDec(Wire.read());
   *month      = bcdToDec(Wire.read());
   *year       = bcdToDec(Wire.read());
}

void setup()
{
   Serial.flush(); // naley wyczyci bufor portu szeregowego
   Serial.begin(9600);
   Wire.begin();
   lcd.begin(16, 2);
   // ustawia pocztkow godzin:
   // DS3232 sekundy, minuty, godziny, dzie tygodnia, dzie miesica, miesic, rok
   //setDS3232time(0, 27, 0, 5, 15, 11, 12);

   // sprawdza, czy karta microSD jest dostpna i gotowa do uycia
   if (!SD.begin(8))
   {
      lcd.print("Karta microSD BD");
      // zatrzymuje wykonywanie szkicu
      return;
   }
   lcd.print("Karta microSD OK");
   delay(1000);
   lcd.clear();
}

// porwnuje dwie tablice i zwraca warto true, jeli s identyczne
// funkcja sprawdza si podczas porwnywania identyfikatorw RFID
boolean comparetag(int aa[14], int bb[14])
{
   boolean ff=false;
   int fg=0;
   for (int cc=0; cc<14; cc++)
   {
      if (aa[cc]==bb[cc])
      {
         fg++;
      }
   }
   if (fg==14)
   {
      ff=true; // wszystkie 14 elementw tablicy s takie same
   }
   return ff;
}

void wipeNewTag()
{
   for (int i=0; i<=14; i++)
   {
      newtag[i]=0;
   }
}

void loop()
{
   byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;

   if (Serial.available() > 0) // jeli umieszczono etykiet w ssiedztwie czytnika,
   {
      // naley odczyta liczb przekazan za porednictwem pinu szeregowego RX
      delay(100); // czas potrzebny na przesanie danych z bufora portu szeregowego
      for (int z=0; z<14; z++) // odczytuje pozostae liczby identyfikatora
      {
         data1=Serial.read();
         newtag[z]=data1;
      }
      Serial.flush(); // usuwa z bufora ewentualne kolejne odczyty
      // pobiera dane z moduu DS3232
      readDS3232time(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month,
      &year);
   }

   // tutaj naley podj kroki zalenie od dopasowania identyfikatorw
   if (comparetag(newtag, Mary) == true)
   {
      lcd.print("Witaj, Mario ");
      File dataFile = SD.open("DATA.TXT", FILE_WRITE);
      if (dataFile)
      {
         dataFile.print("Maria ");
         dataFile.print(hour);
         dataFile.print(":");
         if (minute<10) { dataFile.print("0"); }
         dataFile.print(minute);
         dataFile.print(":");
         if (second<10) { dataFile.print("0"); }
         dataFile.print(second);
         dataFile.print(" ");
         dataFile.print(dayOfMonth);
         dataFile.print("/");
         dataFile.print(month);
         dataFile.print("/");
         dataFile.print(year);
         dataFile.println();
         dataFile.close();
      }
      delay(1000);
      lcd.clear();
      wipeNewTag();
   }

   if (comparetag(newtag, John)==true)
   {
      lcd.print("Witaj, Janie ");
      File dataFile = SD.open("DATA.TXT", FILE_WRITE);
      if (dataFile)
      {
         dataFile.print("Jan   ");
         dataFile.print(hour);
         dataFile.print(":");
         if (minute<10) { dataFile.print("0"); }
         dataFile.print(minute);
         dataFile.print(":");
         if (second<10) { dataFile.print("0"); }
         dataFile.print(second);
         dataFile.print(" ");
         dataFile.print(dayOfMonth);
         dataFile.print("/");
         dataFile.print(month);
         dataFile.print("/");
         dataFile.print(year);
         dataFile.println();
         dataFile.close();
      }
      delay(1000);
      lcd.clear();
      wipeNewTag();
   }
}
