// Projekt nr 58  tworzenie prostego zegara cyfrowego

#include "Wire.h"
#define DS3232_I2C_ADDRESS 0x68

#include <LiquidCrystal.h>
LiquidCrystal lcd( 8, 9, 4, 5, 6, 7 );

// Konwertuje liczby dziesitne na zakodowane wartoci binarne
byte decToBcd(byte val)
{
   return( (val/10*16) + (val%10) );
}

// Konwertuje zakodowane wartoci binarne na liczby dziesitne
byte bcdToDec(byte val)
{
   return( (val/16*10) + (val%16) );
}

void setup()
{
   Wire.begin();
   lcd.begin(16, 2);
   // ustawia pocztkow godzin:
   // DS3232 sekundy, minuty, godziny, dzie tygodnia, dzie miesica, miesic, rok
   //setDS3232time(0, 27, 0, 5, 15, 11, 12);
}

void setDS3232time(byte second, byte minute, byte hour, byte dayOfWeek, byte
dayOfMonth, byte month, byte year)
{
   // ustawia dat i godzin w module DS3232
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // okrela, e nastpna warto ma trafi do rejestru sekund
   Wire.write(decToBcd(second));     // ustawia sekundy
   Wire.write(decToBcd(minute));     // ustawia minuty
   Wire.write(decToBcd(hour));       // ustawia godziny
   Wire.write(decToBcd(dayOfWeek));  // ustawia dzie tygodnia (1 = niedziela, 7 = sobota)
   Wire.write(decToBcd(dayOfMonth)); // ustawia dzie miesica (od 1 do 31)
   Wire.write(decToBcd(month));      // ustawia miesic
   Wire.write(decToBcd(year));       // ustawia rok (od 0 do 99)
   Wire.endTransmission();
}

void readDS3232time(byte *second,
byte *minute,
byte *hour,
byte *dayOfWeek,
byte *dayOfMonth,
byte *month,
byte *year)
{
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // ustawia wskanik rejestru DS3232 na pozycji 00h
   Wire.endTransmission();
   Wire.requestFrom(DS3232_I2C_ADDRESS, 7);
   // da siedmiu bajtw danych od moduu DS3232, poczwszy od rejestru 00h
   *second     = bcdToDec(Wire.read() & 0x7f);
   *minute     = bcdToDec(Wire.read());
   *hour       = bcdToDec(Wire.read() & 0x3f);
   *dayOfWeek  = bcdToDec(Wire.read());
   *dayOfMonth = bcdToDec(Wire.read());
   *month      = bcdToDec(Wire.read());
   *year       = bcdToDec(Wire.read());
}

void displayTime()
{
   byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;

   // pobiera dane z moduu DS3232
   readDS3232time(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month,
   &year);

   // wysya dane do moduu LCD
   lcd.clear();
   lcd.setCursor(4,0);
   lcd.print(hour, DEC);
   lcd.print(":");
   if (minute<10)
   {
      lcd.print("0");
   }
   lcd.print(minute, DEC);
   lcd.print(":");
   if (second<10)
   {
      lcd.print("0");
   }
   lcd.print(second, DEC);

   lcd.setCursor(0,1);
   switch(dayOfWeek){
      case 1:
         lcd.print("Nie");
         break;
      case 2:
         lcd.print("Pon");
         break;
      case 3:
         lcd.print("Wto");
         break;
      case 4:
         lcd.print("Sro");
         break;
      case 5:
         lcd.print("Czw");
         break;
      case 6:
         lcd.print("Pia");
         break;
      case 7:
         lcd.print("Sob");
         break;
   }
   lcd.print(" ");
   lcd.print(dayOfMonth, DEC);
   lcd.print("/");
   lcd.print(month, DEC);
   lcd.print("/");
   lcd.print(year, DEC);
}

void loop()
{
   displayTime(); // wywietla na LCD dat i godzin pobrane z zegara czasu rzeczywistego
   delay(1000);   // cykl jest powtarzany co sekund
}
