// Projekt nr 51  budowa zdalnie sterowanego robota

int receiverpin = 11;       // pin nr 1 odbiornika podczerwieni poczono z pinem cyfrowym nr 11 na pytce Arduino
#include <IRremote.h>

IRrecv irrecv(receiverpin); // tworzy obiekt funkcji IRrecv
decode_results results;

int m1speed     = 6; // piny cyfrowe uywane do sterowania szybkoci
int m2speed     = 5;
int m1direction = 7; // piny cyfrowe uywane do sterowania kierunkiem pracy silnikw
int m2direction = 4;

void setup()
{
   pinMode(m1direction, OUTPUT);
   pinMode(m2direction, OUTPUT);
   irrecv.enableIRIn(); // uruchamia odbiornik podczerwieni
}

void goForward(int duration, int pwm)
{
   digitalWrite(m1direction, HIGH); // ruch w przd
   digitalWrite(m2direction, HIGH); // ruch w przd
   analogWrite(m1speed, pwm);       // z okrelon szybkoci
   analogWrite(m2speed, pwm);
   delay(duration);                 // czas ruchu
   analogWrite(m1speed, 0);         // nastpnie robot zatrzymuje si
   analogWrite(m2speed, 0);
}

void goBackward(int duration, int pwm)
{
   digitalWrite(m1direction, LOW); // ruch w ty
   digitalWrite(m2direction, LOW); // ruch w ty
   analogWrite(m1speed, pwm);      // z okrelon szybkoci
   analogWrite(m2speed, pwm);
   delay(duration);
   analogWrite(m1speed, 0);        // nastpnie robot zatrzymuje si
   analogWrite(m2speed, 0);
}

void rotateRight(int duration, int pwm)
{
   digitalWrite(m1direction, HIGH); // ruch w przd
   digitalWrite(m2direction, LOW);  // ruch w ty
   analogWrite(m1speed, pwm);       // z okrelon szybkoci
   analogWrite(m2speed, pwm);
   delay(duration);                 // czas ruchu
   analogWrite(m1speed, 0);         // nastpnie robot zatrzymuje si
   analogWrite(m2speed, 0);
}

void rotateLeft(int duration, int pwm)
{
   digitalWrite(m1direction, LOW);  // ruch w ty
   digitalWrite(m2direction, HIGH); // ruch w przd
   analogWrite(m1speed, pwm);       // z okrelon szybkoci
   analogWrite(m2speed, pwm);
   delay(duration);                 // czas ruchu
   analogWrite(m1speed, 0);         // nastpnie robot zatrzymuje si
   analogWrite(m2speed, 0);
}

// funkcja translateIR podejmuje dziaania zalenie od otrzymanego kodu IR (wedug standardw Sony)
void translateIR()
{
   switch(results.value)
   {
      case 0x810: goForward(250, 255);   break; // 2
      case 0xC10: rotateLeft(250, 255);  break; // 4
      case 0xA10: rotateRight(250, 255); break; // 6
      case 0xE10: goBackward(250, 255);  break; // 8
   }
}

void loop()
{
   if (irrecv.decode(&results)) // sprawdza, czy otrzymano sygna IR
   {
      translateIR();
      for (int z = 0 ; z < 2 ; z++) // ignoruje powtrzenia kodu
      {
         irrecv.resume(); // odbiera nastpn warto
      }
   }
}
