// Projekt nr 50  zdalne sterowanie systemem Arduino na podczerwie

int receiverpin = 11;       // pin nr 1 odbiornika podczerwieni poczono z pinem cyfrowym nr 11 na pytce Arduino
#include <IRremote.h>
IRrecv irrecv(receiverpin); // tworzy obiekt funkcji IRrecv
decode_results results;

void setup()
{
   irrecv.enableIRIn(); // uruchamia odbiornik
   for (int z = 2 ; z < 8 ; z++) // konfiguruje piny cyfrowe
   {
      pinMode(z, OUTPUT);
   }
}

void translateIR()
// podejmuje dziaania zalenie od otrzymanego kodu IR
// (na podstawie kodw stosowanych w produktach Sony)
{
   switch(results.value)
   {
      case 0x810: pinOn(2); break; // 2
      case 0x410: pinOn(3); break; // 3
      case 0xC10: pinOn(4); break; // 4
      case 0x210: pinOn(5); break; // 5
      case 0xA10: pinOn(6); break; // 6
      case 0x610: pinOn(7); break; // 7
   }
}

void pinOn(int pin) // wcza pin cyfrowy na 1 sekund
{
   digitalWrite(pin, HIGH);
   delay(1000);
   digitalWrite(pin, LOW);
}

void loop()
{
   if (irrecv.decode(&results)) // sprawdza, czy otrzymano sygna IR
   {
      translateIR();
      for (int z = 0 ; z < 2 ; z++) // ignoruje drugie i trzecie powtrzenie kodu
      {
         irrecv.resume(); // odbiera nastpn warto
      }
   }
}
