// Projekt nr 53  budowa systemu kontroli dostpu RFID z pamici ostatniej akcji

#include <EEPROM.h>
int data1 = 0;
int ok = -1;
int lockStatus = 0;

// identyfikatory etykiet RFID mona sprawdzi za pomoc szkicu z listingu 16.1
int tag1[14] = {x, x, x, x, x, x, x, x, x, x, x, x, x, x};
int tag2[14] = {x, x, x, x, x, x, x, x, x, x, x, x, x, x};

int newtag[14] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0}; // tablica uywana do porwnywania odczytanego identyfikatora

void setup()
{
   Serial.flush();
   Serial.begin(9600);
   pinMode(13, OUTPUT);
   checkLock();
}

// funkcja comparetag() porwnuje dwie tablice i zwraca warto true, jeli s identyczne
// funkcja sprawdza si podczas porwnywania identyfikatorw RFID
boolean comparetag(int aa[14], int bb[14])
{
   boolean ff = false;
   int fg = 0;
   for (int cc = 0; cc < 14; cc++)
   {
      if (aa[cc] == bb[cc])
      {
         fg++;
      }
   }
   if (fg == 14)
   {
      ff = true;
   }
   return ff;
}

void checkmytags()
// porwnuje oba zapisane identyfikatory z wanie odczytanym identyfikatorem
{
   ok = 0;
   if (comparetag(newtag, tag1) == true)
   {
      ok++;
   }
   if (comparetag(newtag, tag2) == true)
   {
      ok++;
   }
}

void checkLock()
{
   Serial.print("Stan systemu po ponownym uruchomieniu ");
   lockStatus = EEPROM.read(0);
   if (lockStatus == 1)
   {
      Serial.println("- zablokowany");
      digitalWrite(13, HIGH);
   }
   if (lockStatus == 0)
   {
      Serial.println("- odblokowany");
      digitalWrite(13, LOW);
   }
   if ((lockStatus != 1) && (lockStatus != 0))
   {
      Serial.println("Bd pamici EEPROM - zmie pytk Arduino");
   }
}

void loop()
{
   ok = -1;
   if (Serial.available() > 0) // jeli umieszczono etykiet w ssiedztwie czytnika,
   {
      // naley odczyta liczb przekazan za porednictwem pinu szeregowego RX
      delay(100);
      for (int z = 0; z < 14; z++) // odczytuje pozostae liczby identyfikatora
      {
         data1 = Serial.read();
         newtag[z] = data1;
      }
      Serial.flush(); // zapobiega wielokrotnym odczytom tego samego identyfikatora
      // czas porwna identyfikatory
      checkmytags();
   }
   if (ok > 0) // jeli identyfikatory s takie same
   {
      lockStatus = EEPROM.read(0);
      if (lockStatus == 1) // jeli zablokowany, odblokowuje
      {
         Serial.println("Stan - odblokowany");
         digitalWrite(13, LOW);
         EEPROM.write(0, 0);
      }
      if (lockStatus == 0)
      {
         Serial.println("Stan - zablokowany");
         digitalWrite(13, HIGH);
         EEPROM.write(0, 1);
      }
      if ((lockStatus != 1) && (lockStatus != 0))
      {
         Serial.println("Bd pamici EEPROM - zmie pytk Arduino");
      }
   }
   else if (ok == 0) // jeli identyfikatory s rne
   {
      Serial.println("Nieprawidowa etykieta");
      ok = -1;
   }
   delay(500);
}
