// Projekt nr 44  budowa prostego odbiornika GPS
#include <TinyGPS.h>
#include <LiquidCrystal.h>
LiquidCrystal lcd( 8, 9, 4, 5, 6, 7 );

// Tworzy obiekt typu TinyGPS:
TinyGPS gps;

void getgps(TinyGPS &gps);

void setup()
{
   Serial.begin(4800);
   lcd.begin(16, 2);
}

void getgps(TinyGPS &gps)
// Funkcja getgps wywietla dane dane na ekranie LCD
{
   float latitude, longitude;
   // dekoduje i wywietla biec pozycj
   gps.f_get_position(&latitude, &longitude);
   lcd.setCursor(0,0);
   lcd.print("Szer:");
   lcd.print(latitude,5);
   lcd.print(" ");
   lcd.setCursor(0,1);
   lcd.print("Dug:");
   lcd.print(longitude,5);
   lcd.print(" ");
   delay(3000); // czeka 3 sekundy
   lcd.clear();
}

void loop()
{
   byte a;
   if ( Serial.available() > 0 ) // jeli otrzymano dane za porednictwem portu szeregowego...
   {
      a = Serial.read();          // ...pobiera bajt danych
      if(gps.encode(a))           // jeli otrzymano prawidowe dane GPS...
      {
         getgps(gps);             // ...pobiera te dane i wywietla je na ekranie LCD
      }
   }
}
