// Projekt nr 45  budowa precyzyjnego zegara korzystajcego z systemu GPS
#include <TinyGPS.h>
#include <LiquidCrystal.h>
LiquidCrystal lcd( 8, 9, 4, 5, 6, 7 );

// Tworzy obiekt typu TinyGPS:
TinyGPS gps;

void getgps(TinyGPS &gps);

void setup()
{
   Serial.begin(4800);
   lcd.begin(16, 2);
}

void getgps(TinyGPS &gps)
{
   int year,a,t;
   byte month, day, hour, minute, second, hundredths;
   gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);

   hour=hour+1; // naley poprawi zgodnie ze stref czasow
   if (hour>23)
   {
      hour=hour-24;
   }
   lcd.setCursor(0,0); // wywietla dat i godzin
   lcd.print("Aktualna godzina ");
   lcd.setCursor(4,1);
   if (hour<10)
   {
      lcd.print("0");
   }
   lcd.print(hour, DEC);
   lcd.print(":");
   if (minute<10)
   {
      lcd.print("0");
   }
   lcd.print(minute, DEC);
   lcd.print(":");
   if (second<10)
   {
      lcd.print("0");
   }
   lcd.print(second, DEC);
}

void loop()
{
   byte a;
   if ( Serial.available() > 0 ) // jeli otrzymano dane za porednictwem portu szeregowego...
   {
      a = Serial.read();          // ...pobiera bajt danych
      if(gps.encode(a))           // jeli otrzymano prawidowe dane GPS...
      {
         getgps(gps);              // ...pobiera te dane i wywietla je na ekranie LCD
      }
   }
}
