// Projekt nr 30  budowa urzdzenia rejestrujcego temperatur

#include <SD.h>
float sensor, voltage, celsius;

void setup()
{
   Serial.begin(9600);
   Serial.print("Inicjalizacja karty SD...");
   pinMode(10, OUTPUT);

   // sprawdza, czy karta microSD jest dostpna i gotowa do uycia
   if (!SD.begin(8))
   {
      Serial.println("Brak lub nieprawidowe dziaanie karty");
      // zatrzymuje wykonywanie szkicu
      return;
   }
   Serial.println("Karta microSD jest gotowa");
}

void loop()
{
   // tworzy plik, w ktrym bd zapisywane dane
   File dataFile = SD.open("DATA.TXT", FILE_WRITE);
   // jeli plik jest gotowy, mona zapisa dane
   if (dataFile)
   {
      for ( int a = 0 ; a < 481 ; a++ ) // 8 godzin to 480 minut
      {
         sensor = analogRead(0);
         voltage = (sensor * 5000) / 1024; // konwertuje wskazanie czujnika na
                                           // miliwolty
         voltage = voltage - 500;
         celsius = voltage / 10;
         dataFile.print(" Zapis temperatury: ");
         dataFile.print(a, DEC);
         dataFile.print(" Temperatura: ");
         dataFile.print(celsius, 2);
         dataFile.println(" stopni Celsjusza");
         delay(599900); // czeka troch poniej jednej minuty
      }
      dataFile.close(); // zamknicie pliku jest konieczne
      Serial.println("Koniec!");
      do {} while (1);
   }
}
