// Projekt nr 22  wywietlanie obrazw na wywietlaczu matrycowym LED
#define DATA 6     // poczenie z pinem nr 14 rejestru 74HC595
#define LATCH 8    // poczenie z pinem nr 12 rejestru 74HC595
#define CLOCK 10   // poczenie z pinem nr 11 rejestru 74HC595

void setup()
{
   pinMode(LATCH, OUTPUT);
   pinMode(CLOCK, OUTPUT);
   pinMode(DATA, OUTPUT);
   randomSeed(analogRead(0));
}

int binary[] = {1, 2, 4, 8, 16, 32, 64, 128};
int r, c = 0;

void setLED(int row, int column, int del)
{
   digitalWrite(LATCH, LOW);
   shiftOut(DATA, CLOCK, MSBFIRST, ~binary[column]); // kolumny
   shiftOut(DATA, CLOCK, MSBFIRST,  binary[row]);    // wiersze
   digitalWrite(LATCH, HIGH);
   delay(del);
}

void loop()
{
   r = random(8);
   c = random(8);
   setLED(r, c, 1); // wcza losowo wybran diod na 1 milisekund
}
