// Projekt nr 20  budowa termometru cyfrowego
#define DATA 6     // poczenie z pinem nr 14 rejestru 74HC595
#define LATCH 8    // poczenie z pinem nr 12 rejestru 74HC595
#define CLOCK 10   // poczenie z pinem nr 11 rejestru 74HC595

int temp = 0;
float voltage = 0;
float celsius = 0;
float sensor = 0;
int digits[]={
   252, 96, 218, 242, 102, 182, 190, 224, 254, 246, 238, 62, 156, 122, 158, 142};

void setup()
{
   pinMode(LATCH, OUTPUT);
   pinMode(CLOCK, OUTPUT);
   pinMode(DATA, OUTPUT);
}

void displayNumber(int n)
{
   int left, right = 0;
   if (n < 10)
   {
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[n]);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[0]);
      digitalWrite(LATCH, HIGH);
   }
   if (n >= 10)
   {
      right = n % 10;
      left = n / 10;
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[right]);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[left]);
      digitalWrite(LATCH, HIGH);
   }
}

void loop()
{
   sensor = analogRead(5);
   voltage = (sensor * 5000) / 1024; // konwertuje wskazanie czujnika na miliwolty
   voltage = voltage - 500;          // odejmuje przesunicie stosowane dla napicia
   celsius = voltage / 10;           // konwertuje miliwolty na stopnie Celsjusza
   temp = int(celsius); // zmienia zmiennoprzecinkow warto temperatury na reprezentacj cakowitoliczbow
   displayNumber(temp);
   delay(500);
}
