// Projekt nr 18  tworzenie wywietlacza jednocyfrowego
#define DATA 6       // poczenie z pinem nr 14 rejestru 74HC595
#define LATCH 8      // poczenie z pinem nr 12 rejestru 74HC595
#define CLOCK 10     // poczenie z pinem nr 11 rejestru 74HC595

// definiuje tablic z dziesitn reprezentacj segmentw wywietlacza dla cyfr od 0 do 9 i liter od A do F (patrz tabela 6.2)
int digits[] = {252, 96, 218, 242, 102, 182, 190, 224, 254, 246, 238, 62, 156, 122, 158, 142};

void setup()
{
   pinMode(LATCH, OUTPUT);
   pinMode(CLOCK, OUTPUT);
   pinMode(DATA, OUTPUT);
}

void loop()
{
   int i;
   for ( i = 0 ; i < 16 ; i++ ) // wywietla cyfry 0  9 i litery A  F
   {
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[i]);
      digitalWrite(LATCH, HIGH);
      delay(250);
   }
   for ( i = 0 ; i < 16 ; i++ ) // wywietla cyfry 0  9 i litery A  F z wczon diod DP
   {
      digitalWrite(LATCH, LOW);
      shiftOut(DATA, CLOCK, LSBFIRST, digits[i]+1); // +1 powoduje wczenie bitu dla diody DP
      digitalWrite(LATCH, HIGH);
      delay(250);
   }
}
