#include <SD.h>

const int chipSelect = 4;

void setup()
{
  Serial.begin(9600);
  Serial.print("Inicjalizacja karty SD...");
  // Sprawdzenie, czy domylny pin chip select jest ustawiony 
  // jako wyjcie, nawet jeeli nie jest uywany
  pinMode(10, OUTPUT);

  // Sprawdzenie, czy karta jest dostpna i moe by zainicjowana
  if (!SD.begin(chipSelect)) {
    Serial.println("Blad karty lub karta niedostepna");
    // Nic wicej nie robimy
    return;
  }
  Serial.println("card initialized.");
}

void loop()
{
  // Utworzenie zmiennej String gromadzcej dane do rejestrowania
  String dataString = "";

  // Odczyt wejcia analogowego nr 0 i zapisanie w dataString
  int sensor = analogRead(0);
  dataString += String(sensor);

  // Otwarcie pliku. Uwaga, tylko jeden plik moe by otwarty w danej chwili,
  // dlatego trzeba go zamkn przed otwarciem nastpnego
  File dataFile = SD.open("datalog.txt", FILE_WRITE);

  // Jeeli plik jest dostpny, zapisujemy do niego
  if (dataFile) {
    dataFile.println(dataString);
    dataFile.close();
    // Dodatkowo wywietlenie danych na porcie szeregowym
    Serial.println(dataString);
  }  
  // Jeeli plik nie jest otwarty, zgo bd
  else {
    Serial.println("Blad otwarcia pliku datalog.txt");
  } 
}










