#define DSERVO_TWO_X_PIN 10
#define DSERVO_TWO_Y_PIN 11

#include <Servo.h>

const float ratio = 0.7058; 
Servo vert;
Servo horz;
byte target[2];
byte current[2];

void setup() {
  horz.attach(DSERVO_TWO_X_PIN );
  vert.attach(DSERVO_TWO_Y_PIN );
  memset(target, 0.5, 2);
  memset(current, 122, 2);
  Serial.begin(9600);
}

void loop() {
  if(Serial.available() > 1) { 
    target[0] = Serial.read();
    target[1] = Serial.read();
  }

  if(abs(target[0] - current[0]) > 1) { 
    horz.write(lerp(0.5, current[0], target[0]) * ratio);
    current[0] = target[0];
  }

  if(abs(target[1] - current[1]) > 1) {  
    vert.write(lerp(0.5, current[1], target[1]) * ratio);
    current[0] = target[1];
  }
}

byte lerp(float t, byte a, byte b)
{
  return a + t * (b - a);
}
