#include <AFMotor.h>
#include <Servo.h>

AF_DCMotor motor(1);  
Servo servo;
 
const int MOTOR_FWD_BUTTON = 2;
const int MOTOR_BWD_BUTTON = 13;
const int POTENTIOMETER_PIN = 0;

int motorSpeed;
int motorState;

const int BACKWARDS = 2;
const int FORWARDS = 1;
const int STOPPED = 0;

void setup() {
  servo1.attach(9);

  pinMode(MOTOR_FWD_BUTTON, INPUT);
  pinMode(MOTOR_BWD_BUTTON, INPUT);
}

void loop() {
  int tmp = analogRead(POTENTIOMETER_PIN);

  int fwd = digitalRead(MOTOR_FWD_BUTTON);
  int bwd = digitalRead(MOTOR_BWD_BUTTON);

  if(fwd == HIGH) {
    if( motorState == BACKWARDS || motorState == STOPPED) {
      motorState = FORWARDS;
      motor.run( FORWARD );
    }
  }

  if(bwd == HIGH) {
    if( motorState == FORWARDS || motorState == STOPPED) {
      motorState = BACKWARDS;
      motor.run( BACKWARD );
    }
  }

  if( tmp != motorSpeed / 4) {  
    motorSpeed = tmp;
    motor.setSpeed( motorSpeed / 4);
  }

  if( motorState == FORWARDS ) {
    servo.write( motorSpeed / 1024. * 90 + 90 );
  } else {
    servo.write( 90 - (motorSpeed / 1024. * 90) );
  }
}
