#include <SoftwareSerial.h>
#include "serLCD.h"
#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 8

serLCD myLcd(12);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

void setup(void)
{
  myLcd.begin(9600);
  sensors.begin();
  myLcd.clear();
}

void displayTemperature(int sensorIndex)
{
  myLcd.clear();
  float tempInCel = sensors.getTempCByIndex(sensorIndex);
  myLcd.setCursor(0,0);
  myLcd.print("C: ");
  myLcd.print(tempInCel, 1);
  myLcd.setCursor(0,1);
  myLcd.print(" F: ");
  float tempInFar = DallasTemperature::toFahrenheit(tempInCel);
  myLcd.print(tempInFar, 1);

}

void loop(void)
{ 
  sensors.requestTemperatures();
  displayTemperature(0);
  delay(2000);
}




