#include <SdFat.h>

SdFat sd;
SdFile myFile;

const int chipSelect = 2;
const int READ_BUTTON = 3;
const int WRITE_BUTTON = 4;

void setup() {
  Serial.begin(57600);
  if (!sd.begin(chipSelect, SPI_HALF_SPEED)) 
    sd.initErrorHalt();
  pinMode(READ_BUTTON, INPUT);
  pinMode(WRITE_BUTTON, INPUT);
}

void loop() {
  if( digitalRead( WRITE_BUTTON )) {
    if (!myFile.open("logger.txt", O_RDWR | O_CREAT | O_AT_END)) {
      sd.errorHalt("Błąd otwarcia pliku logger.txt do zapisu");
      return;
    }
    myFile.print("Przycisk naciśnięty po upływie ");
    myFile.print( millis() );
    myFile.print( " milisekund od startu ");
    myFile.close(); 
  }
  if(digitalRead( READ_BUTTON) ) {
    if (!myFile.open("logger.txt", O_READ)) { 
      sd.errorHalt("Błąd otwarcia pliku logger.txt do odczytu");
      return;
    }

    int data;
    while ((data = myFile.read()) > 0) {
      Serial.write(data);
    }
    myFile.close(); 
  }
}
