#include <AFMotor.h>

AF_Stepper stepper(48, 1);

const int STEPPER_BWD_BUTTON = 2;
const int STEPPER_FWD_BUTTON = 13;

const int BACKWARDS = 2;
const int FORWARDS = 1;
const int STOPPED = 0;

int motorState;

void setup() {
  }

void loop() {
  int fwd = digitalRead(STEPPER_FWD_BUTTON);
  int bwd = digitalRead(STEPPER_BWD_BUTTON);

  if(fwd == HIGH) {  
    if( motorState == FORWARDS ) {
      motorState = STOPPED;
    } else {
      motorState = FORWARDS;
    }
  }

  if(bwd == HIGH) {
    if( motorState == BACKWARDS ) {
      motorState = STOPPED;
    } else {
      motorState = BACKWARDS;
    }
  }

  if(motorState == FORWARDS) {
    stepper.step(1, FORWARD, INTERLEAVE);
  } else if(motorState == BACKWARDS) {
    stepper.step(1, BACKWARD, INTERLEAVE);
  }
}
