const int LFORCE = 0;
const int RFORCE = 1;

const int pressLength = 10000;

const int LTURNSIGNAL = 2;  
const int RTURNSIGNAL = 3;

int lPrevious, rPrevious;

boolean leftOn, rightOn;

int pressTime;

void setup()
{
  pinMode(LTURNSIGNAL, OUTPUT);
  pinMode(RTURNSIGNAL, OUTPUT);

  leftOn = false;
  rightOn = false;
}

void loop()
{
  int lCurr = analogRead(LFORCE);
  int rCurr = analogRead(RFORCE);
  if( lCurr - lPrevious > 200) {  
    pressTime = millis();
    leftOn = true;
  }
  lPrevious = lCurr;

  if( rCurr - rPrevious > 200) {
    pressTime = millis();
    rightOn = true;
  }
  rPrevious = rCurr;

  if(leftOn) {
    digitalWrite(LTURNSIGNAL, HIGH);
    if( millis() - pressTime > pressLength) {  
      leftOn = false;
    }
  }

  if(rightOn) {
    digitalWrite(RTURNSIGNAL, HIGH);
    if( millis() - pressTime > pressLength) {
      rightOn = false;
    }
  }
}
