#include <SPI.h>
#include <Ethernet.h>

#define APIKEY          "TWOJ KLUCZ API"       // Zamie na swj klucz API (to musi by tekst)
#define FEEDID          12345                  // Zamie na swj ID kanau (to musi by liczba cakowita)
#define PROJECTNAME     "Arduino w akcji"      // Zamie na nazw swojego projektu (to musi by tekst)

byte mac[] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED};
IPAddress ip(192,168,0,120);
EthernetClient client;

long lastConnectionTime = 0;        // Czas w milisekundach ostatniego poczenia z serwerem
boolean lastConnected = false;      // Status ostatniego poczenia wewntrz gwnej ptli
const int postingInterval = 10000;  // Czstotliwo aktualizacji w Xively, np. 10000 = 10 sekund

void setup() {
   // Prba poczenia przy uyciu adresu IP przypisanego automatycznie (DHCP)
   // Jeeli si nie uda, prba poczenia przy uyciu adresu IP przypisanego rcznie
  if (!Ethernet.begin(mac)){
    Ethernet.begin(mac, ip);
  }

  // Uruchomienie portu szeregowego
  Serial.begin(9600);
}

void loop() {
  // Odczyt czujnika analogowego
  int sensorReading = analogRead(A0);   

  // Jeeli s dane przychodzce z sieci, wylij je na port szeregowy
  // Tylko do celw diagnostycznych
  if (client.available()) {
    char c = client.read();
    Serial.print(c);
  }

  // Jeeli nie ma poczenia z sieci, ale byo w w ostatnim wykonaniu ptli,
  // zatrzymaj klienta
  if (!client.connected() && lastConnected) {
    Serial.println();
    Serial.println("Rozlaczony.");
    client.stop();
  }

  // Jeeli nie jeste poczony i mino 10 sekund od ostatniego poczenia,
  // pocz si ponownie i wylij dane
  if(!client.connected() && (millis() - lastConnectionTime > postingInterval)) {
    sendData(sensorReading);
  }
  // Zapisz stan poczenia dla nastpnego wykonania ptli
  lastConnected = client.connected();
}

// Metoda nawizujca poczenie HTTP z serwerem
void sendData(int thisData) {
  // Jeeli poczenie udao si nawiza
  if (client.connect("api.xively.com", 80)) {
    Serial.println("Laczenie...");
    // Wylij danie HTTP PUT z ID kanau i kluczem API okrelonym wczeniej
    client.print("PUT /v2/feeds/");
    client.print(FEEDID);
    client.println(".csv HTTP/1.1");
    client.println("Host: api.xively.com ");
    client.print("X-ApiKey: ");
    client.println(APIKEY);
    client.print("User-Agent: ");
    client.println(PROJECTNAME);
    client.print("Content-Length: ");

    // Obliczenie dugoci danych z czujnika w bajtach (dodanie 8 dla "czujnik1")
    int thisLength = 8 + getLength(thisData);
    client.println(thisLength);

    // Ostatnie elementy dania HTTP PUT 
    client.println("Content-Type: text/csv");
    client.println("Connection: close");
    client.println();

    // Waciwa zawarto (dane) dania PUT
    client.print("czujnik1, ");
    client.println(thisData);
  } 
  else {
    // Jeeli nie mona nawiza poczenia
    Serial.println("Blad polaczenia.");
    Serial.println("Rozlaczony.");
    client.stop();
  }
    // Zapisanie czasu ostatniego poczenia 
    lastConnectionTime = millis();
}

// Metoda obliczajca iloci cyfr w odczycie z czujnika.
// Poniewa kada cyfra w tekstowej postaci liczby
// zajmuje jeden bajt, wic ilo cyfr jest rwna liczbie bajtw
int getLength(int someValue) {
  // Jest przynajmniej jeden bajt
  int digits = 1;
  // Cige dzielenie liczby przez 10, dodawanie
  // jednoci do iloci cyfr po kadym dzieleniu,
  // a do osignicia wartoci 0
  int dividend = someValue /10;
  while (dividend > 0) {
    dividend = dividend /10;
    digits++;
  }
  // Zwrcenie iloci cyfr
  return digits;
}

