const int calibrationTime = 30;  // Zapewnienie odpowiedniego czasu na kalibracj 
const unsigned long pause = 5000;

unsigned long lowIn;
boolean waitForLow = true;
int pirPin = 3;

void setup()
{
  Serial.begin(57600);
  pinMode(pirPin, INPUT);
  digitalWrite(pirPin, LOW);
}

void loop()
{
 if(calibrationTime > 1) {
    calibrationTime--;
    delay(1000);
    return;
  }
  if(digitalRead(pirPin) == HIGH) {
    if(!waitForLow && millis() - lowIn > pause) {
      waitForLow = true;
      delay(50);
    }
  }
  if(digitalRead(pirPin) == LOW) {
    if(waitForLow) {
      lowIn = millis();
      waitForLow = false;
    }
    if(!waitForLow && millis() - lowIn > pause) {  // Sprawdzenie ustania ruchu 
      waitForLow = true;
      Serial.print("Czas ruchu ");
      Serial.print((millis() - pause)/1000);
    }
  }
}
