/*
 * szkic ShowSensorData 
 * 
 * Wyświetla wykres danych z czujnika z zakresu od -127 do 127 i odebranych w formacie JSON.
 * wymagany format: "{'label1': value, 'label2': value,}\n" 
 * na przykład:
 * {'x': 1.0, 'y': -1.0, 'z': 2.1,}
 */

import processing.serial.*;
import java.util.Set;

Serial myPort;  // tworzenie obiektu klasy Serial
PFont fontA;    // czcionka wyświetlanego tekstu  
int fontSize = 12;
short LF = 10;        // znak końca linii w ASCII

int rectMargin  = 40;
int windowWidth = 600;
int maxLabelCount = 12; // Zwiększ tą wartość, jeśli potrzebujesz więcej danych.
int windowHeight  = rectMargin + (maxLabelCount + 1) * (fontSize *2);
int rectWidth  = windowWidth - rectMargin*2;
int rectHeight = windowHeight - rectMargin;
int rectCenter = rectMargin + rectWidth / 2;

int origin = rectCenter;
int minValue = -5;
int maxValue = 5;

float scale = float(rectWidth) / (maxValue - minValue);

// UWAGA!
// W razie potrzeby zmień poniższą definicję podając poprawny numer portu.
short portIndex = 0;  // wybór portu szeregowego, 0 oznacza pierwszy port

void settings() {
  size(windowWidth, windowHeight);
}

void setup() {
  println( (Object[]) Serial.list());
  println(" Łączenie z -> " + Serial.list()[portIndex]);
  myPort = new Serial(this, Serial.list()[portIndex], 9600);
  fontA = createFont("Arial.normal", fontSize);  
  textFont(fontA);
}

void draw() {

  if (myPort.available () > 0) {
    String message = myPort.readStringUntil(LF); 
    if (message != null) {
      
      // Odczytaj dane w formacie JSON z wiadomości.
      JSONObject json = new JSONObject();
      try {
        json = parseJSONObject(message);
      }
      catch(Exception e) {
        println("Błąd w odczycie [" + message + "]");
      }

      // Skopiuj nazwy składników i wartości do osobnych tablic.
      ArrayList<String> labels = new ArrayList<String>();
      ArrayList<Float> values = new ArrayList<Float>();
      for (String key : (Set<String>) json.keys()) {
        labels.add(key);
        values.add(json.getFloat(key));
      }

      // rysowanie siatki i wykresu
      background(255); 
      drawGrid(labels);   
      fill(204); 
      for (int i = 0; i < values.size(); i++) {
        drawBar(i, values.get(i));
      }
    }
  }
}

// rysowanie słupka reprezentującego aktualny odczyt z czujnika
void drawBar(int yIndex, float value) { 
  rect(origin, yPos(yIndex)-fontSize, value * scale, fontSize);
}

void drawGrid(ArrayList<String> sensorLabels) {
  fill(0); 

  // rysowanie etykiety i linii minimalnej wartości
  text(minValue, xPos(minValue), rectMargin-fontSize);   
  line(xPos(minValue), rectMargin, xPos(minValue), rectHeight + fontSize); 
  
  // rysowanie etykiety i linii średniej wartości
  text((minValue+maxValue)/2, rectCenter, rectMargin-fontSize);   
  line(rectCenter, rectMargin, rectCenter, rectHeight + fontSize);
  
  // rysowanie etykiety i linii maksymalnej ci
  text(maxValue, xPos(maxValue), rectMargin-fontSize);  
  line(
  xPos(maxValue), rectMargin, xPos(maxValue), rectHeight + fontSize);   

  // wyświetlanie etykiety każdego czujnika
  for (int i=0; i < sensorLabels.size(); i++) {
    text(sensorLabels.get(i), fontSize, yPos(i));
    text(sensorLabels.get(i), xPos(maxValue) + fontSize, yPos(i));
  }
}

// obliczanie pozycji y z uwzględnieniem marginesów i rozmiaru czcionki
int yPos(int index) {
  return rectMargin + fontSize + (index * fontSize*2);
}

// obliczanie pozycji y z uwzględnieniem skali i środka pola wykresu
int xPos(int value) {
  return origin  + int(scale * value);
}
