/*
 * Szkic utimer
 * Miga znajdującą się na płytce diodą LED z częstotliwością podaną za pomocą monitora portu szeregowego
 */

#include "uTimerLib.h"

const int pulsePin = LED_BUILTIN;

int period = 100; // Okres w milisekundach
volatile bool output = HIGH; // Stan pinu

void setup()
{
  pinMode(pulsePin, OUTPUT);
  Serial.begin(9600);
  TimerLib.setInterval_us(flash, period/2 * 1000L);
}

void loop()
{
  if( Serial.available())
  {
    int period = Serial.parseInt();
    if (period)
    {
      Serial.print("Ustawienie okresu na: "); Serial.println(period);
      TimerLib.setInterval_us(flash, period/2 * 1000L);
    }
  }
}

void flash()
{
  digitalWrite(pulsePin, output);
  output = !output;  // Odwrócenie wartości wyjściowej
}
