/*
 * Szkic wifinina
 * Prosi o pewne dane z serwisu Internet Archive
 */

#include <SPI.h>
#include <WiFiNINA.h>

const char ssid[] = "TWÓJ_SSID";
const char password[] = "TWOJE_HASŁO";

WiFiClient client; // Klient Wi-Fi

char serverName[] = "archive.org";
String request = "GET /advancedsearch.php?q=arduino&fl%5B%5D=description"
                 "&rows=1&sort%5B%5D=downloads+desc&output=csv#raw HTTP/1.0";

bool configureNetwork()
{
  int status = WL_IDLE_STATUS; // Status Wi-Fi

  if (WiFi.status() == WL_NO_MODULE)
  {
    Serial.println("Nie udało się odnaleźć sprzętu Wi-Fi.");
    return false;
  }
  String fv = WiFi.firmwareVersion();
  if (fv < WIFI_FIRMWARE_LATEST_VERSION)
  {
    Serial.println("Proszę zaktualizować oprogramowanie modułu Wi-Fi.");
  }
  while (status != WL_CONNECTED)
  {
    Serial.print("Próba połączenia z siecią Wi-Fi:  "); Serial.println(ssid);
    status = WiFi.begin(ssid, password); // Szkic będzie próbował połączyć się z Wi-Fi tak długo, aż połączenie zostanie nawiązane
    delay(1000); // Czekaj 1 s
  }
  return true;
}

void setup()
{
  Serial.begin(9600);
  if (!configureNetwork())
  {
    Serial.println("Zatrzymywanie...");
    while(1); // Zatrzymanie programu
  }
  
  Serial.println("Łączenie z serwerem...");
  int ret = client.connect(serverName, 80); 
  if (ret == 1) 
  {
    Serial.println("Połączono");
    client.println(request);
    client.print("Host: "); client.println(serverName);
    client.println("Połączenie: zamknięte");
    client.println();
  } 
  else 
  {
    Serial.println("Połączenie nieudane z powodu błędu: ");
    Serial.print(ret, DEC);
  }
}

void loop()
{
  if (client.available()) 
  {
    char c = client.read();
    Serial.print(c);  // Przesłanie wszystkich odebranych danych do monitora portu szeregowego
  }
  if (!client.connected()) 
  {
    Serial.println();
    Serial.println("Rozłączanie...");
    client.stop();
    while(1); // Zatrzymanie programu
  }
}
