/*
 * Szkic i2c_secondary
 * Monitoruje żądania I2C i przesyła je do portu szeregowego
 */

#include <Wire.h>

const int address = 4;  // Adres używany przez komunikujące się ze sobą urządzenia

void setup()
{
  Serial.begin(9600);
  Wire.begin(address); // Połączenie magistrali I2C za pomocą tego adresu
  Wire.onReceive(receiveEvent); // Zarejestrowanie wydarzenia obsługującego żądania
}

void loop()
{
  // Nie jest wymagany żaden kod, gdyż wszystko jest wykonywane przez funkcję receiveEvent
}

void receiveEvent(int howMany)
{
  while(Wire.available() > 0)
  {
    char c = Wire.read(); // Odczytanie bajta jako znaku
    Serial.write(c); // Zapis do portu szeregowego
  }
}
