/*
   Szkic adjusttime
   Ustawienie czasu za pomocą przycisków podłączonych do pinów 2 i 3 
 */

#include <TimeLib.h>

const int  btnForward = 2;  // Przycisk do przyspieszania czasu
const int  btnBack = 3;     // Przycisk do cofania czasu

unsigned long  prevtime;   // Zmienna przechowująca informację, kiedy ostatni raz czas był wyświetlany

void setup()
{
  pinMode(btnForward, INPUT_PULLUP);  // Włączenie rezystroów podciągających
  pinMode(btnBack, INPUT_PULLUP);
  setTime(12,0,0,1,1,2020); // Ustawienie czasu początkowego na 12:00,  1 stycznia 2020
  Serial.begin(9600);
}

void loop()
{
  prevtime = now();   // Zapisanie czasu
  while( prevtime == now() )    // Pętla wykonująca się, dopóki nie zmieni się sekunda
  {
    // Czy został wciśniety jeden z przycisków ustawiający czas, podczas czekania na kolejną sekundę?
    if(checkSetTime())
      prevtime = now(); // Jeśli tak, czas się zmienił więc go zresetuj
  }
  digitalClockDisplay();
}
    
// Funkcje sprawdzające czy czas powinien być zmieniony
// Funkcja zwraca prawdę, jeśli czas się zmienił
bool checkSetTime()
{
  int step;   // Liczba sekund do odjęcia (jeśli wartość ujemna) lub dodania
  bool isTimeAdjusted = false;  // Ustawienie na true, jeśli czas został zmieniony
  step = 1;   // Początkowa wartość wykorzystywana do ustawiania godziny 

  while(digitalRead(btnForward)== LOW)
  {
     adjustTime(step);
     isTimeAdjusted = true; // Poinformowanie użytkownika, że czas został zmieniony
     step = step + 1; // Następny krok jest większy
     digitalClockDisplay(); // Aktualizacja zegara   
     delay(100); 
  }
  step = -1;   // Liczby ujemne odejmują czas
  while(digitalRead(btnBack)== LOW)
  {
     adjustTime(step);
     isTimeAdjusted = true; // Poinformowanie użytkownika, że czas został zmieniony
     step = step - 1; // Następny krok ma większą wartość ujemną
     digitalClockDisplay(); // Aktualizacja zegara   
     delay(100); 
  }
  return isTimeAdjusted;  // Poinformowanie użytkownika, czy czas został zmieniony
}

// Dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera przed cyfrą
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);
  
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  Serial.println(datestr);
}
