/*
 * Szkic camera_remote
 * Robi 20 zdjęć aparatem cyfrowym
 * używając pinu 4 dla przysłony i
 * pinu 3 dla migawki
 */

int focus = 4;          // Transoptor podłączony do przysłony
int shutter = 3;        // Transoptor podłączony do migawki
long exposure = 250;    // Czas naświetlania w milisekundach
long interval = 10000;  // Odstęp między kolejnymi zdjęciami, w milisekundach

void setup()
{
  pinMode(focus, OUTPUT);
  pinMode(shutter, OUTPUT);
  for (int i=0; i<20; i++)  // Aparat zrobi 20 zdjęć
  {
    takePicture(exposure);       // Wykonanie zdjęcia
    delay(interval);             // Przerwa przed kolejnym zdjęciem
  }
}

void loop()
{
                  // Po wykonaniu 20 zdjęć program kończy pracę,
                  // dlatego pętla główna jest pusta,
                  // jednak nie można jej wykasować ze szkicu,
                  // gdyż szkic zgłosiłby błąd kompilacji
}

void takePicture(long exposureTime)
{
  int wakeup = 10;      // Czas potrzebny aparatowi na otworzenie przysłony
                        // Dostosuj powyższy czas, aby był odpowiedni dla Twojego aparatu
                                            
  digitalWrite(focus, HIGH);     // Włącz aparat i otwórz przysłonę
  delay(wakeup);                 // Czekaj, aż aparat się włączy i ustawi ostrość
  digitalWrite(shutter, HIGH);   // Otwórz migawkę
  delay(exposureTime);           // Odczekaj ustalony czas naświetlania
  digitalWrite(shutter, LOW);    // Zwolnij migawkę
  digitalWrite(focus, LOW);      // Zamknij przysłonę
}
