/*
 * Szkic mozzi_melody_midinotes
 * Gra kurant Big Bena
 */

#include <MozziGuts.h>
#include <Oscil.h> // Szablon oscylatora
#include <tables/sin2048_int8.h> // Tabela z wartościami sinusa
#include <EventDelay.h>
#include <mozzi_midi.h>

#define CONTROL_RATE 64 // Kontrola wskaźnika częstotliwości (wykorzystuje potęgę 2)

enum notes 
{
  E3 = 52, B4 = 59, E4 = 64, F4S = 66, G4S = 68, REST = 0
};

int score[] = { E4, G4S, F4S, B4, REST,
                E4, F4S, G4S, E4, REST,
                G4S, E4, F4S, B4, REST,
                B4, F4S, G4S, E4, REST,
                E3, REST, E3, REST, E3, REST, E3, REST };
const byte scoreLen = sizeof(score) / sizeof(score[0]);

byte beats[scoreLen] = {2, 2, 2, 2, 2, 
                        2, 2, 2, 2, 2, 
                        2, 2, 2, 2, 2,
                        2, 2, 2, 2, 10, 
                        4, 4, 4, 4, 4, 4, 4, 10};
unsigned int beat_ms = 60000 / 180; // Długość ósemki w milisekundach

const int pauseTime = 200; // Pauza między nutami
int currNote = 0; // Indeks granej nuty
bool pausing = false; // Mała pauza między taktami

Oscil <SIN2048_NUM_CELLS, AUDIO_RATE> aSin(SIN2048_DATA); // Sinusoida
EventDelay kChangeNoteDelay; // Obiekt Delay

void setup() {
  startMozzi(CONTROL_RATE);
  kChangeNoteDelay.start();
}

void updateControl() {
  
  if (kChangeNoteDelay.ready()) { // Czy obiekt Delay jest gotowy?
    pausing = !pausing; // Zmień stan pauzy na przeciwny
    if (pausing) {
      aSin.setFreq(0); // Ustawienie częstotliwości
      kChangeNoteDelay.set(pauseTime); // Pauza 200 ms
    } else {
      if (currNote >= scoreLen) {
        currNote = 0; // Po odegraniu całej melodii, wróć do początku
      }
      int duration = beats[currNote] * beat_ms; // Wykorzystanie tablicy taktów do określenia długości dźwięku
      kChangeNoteDelay.set(duration - pauseTime); // Wstawienie długości dźwięku
      aSin.setFreq(mtof(score[currNote])); // Ustawienie częstotliwości
      currNote++;
    }
    kChangeNoteDelay.start();
  }
}

int updateAudio() {
  return aSin.next(); 
}

void loop() {
  audioHook(); // Musisz mieć to polecenie w swojej funkcji loop
}
