/*
 * szkic matrix_animate_pot
 * Animacja dwóch obrazków serca ilustrująca bicie serca
 */

// Obrazki serc są przechowywane jako bitmapy - każdy bit odpowiada jeden diodzie LED.
// 0 oznacza zgaszoną diodę, a 1 zapaloną.
byte bigHeart[] = {
  B01100110,
  B11111111,
  B11111111,
  B11111111,
  B01111110,
  B00111100,
  B00011000,
  B00000000};

byte smallHeart[] = {
  B00000000,
  B00000000,
  B00010100,
  B00111110,
  B00111110,
  B00011100,
  B00001000,
  B00000000};

const int columnPins[] = { 2, 3, 4, 5, 6, 7, 8, 9};
const int rowPins[]    = {10,11,12,A1,A2,A3,A4,A5};

void setup() {
  for (int i = 0; i < 8; i++)
  {
    pinMode(rowPins[i], OUTPUT);        // ustawienie wszystkich pinów diod LED jako wyjście
    pinMode(columnPins[i], OUTPUT);
    digitalWrite(columnPins[i], HIGH);  // odłączenie pinu kolumny od masy
  }
}

void loop() {
  int sensorValue = analogRead(A0);                // odczyt wejściowej wartości analogowej
  int pulseRate =  map(sensorValue,0,1023,40,240); // zamień na bity na minutę
  int pulseDelay = (60000 / pulseRate);  // odstęp pomiędzy uderzeniami serca (w milisekundach)

  show(smallHeart, 80);            // wyświetlenie małego serca przez 80 ms
  show(bigHeart, 160);             // wyświetlenie dużego serca przez 160 ms
  delay(pulseDelay);               // Nie pokazuj nic między uderzeniami.
}

// wyświetlenie ramki obrazka, która jest przechowywana w tablicy, której wskazaniem jest parametr obrazka
// Ramka powtarzana jest przez czas określony za pomocą drugiego parametru podanego w milisekundach.
void show(byte * image, unsigned long duration)
{
 unsigned long start = millis();            // początek odliczania czasu animacji
 while (start + duration > millis())        // Wykonuj tak długo, aż minie określony czas animacji.
  {
    for(int row = 0; row < 8; row++)
    {
      digitalWrite(rowPins[row], HIGH);          // podłączenie wiersza do napięcia
      for(int column = 0; column < 8; column++)
      {
        bool pixel = bitRead(image[row],column);
        if(pixel == 1)
        {
          digitalWrite(columnPins[column], LOW);  // podłączenie kolumny do masy
        }
        delayMicroseconds(300);                   // małe opóźnienie dla każdej diody LED
        digitalWrite(columnPins[column], HIGH);   // odłączenie kolumny od masy
      }
      digitalWrite(rowPins[row], LOW);            // odłączenie diod LED
    }
  }
}
