/*
 * Szkic blink_leds
 * Miganie trzema diodami LED, podłączonymi do osobnych pinów
 */

const int firstLedPin  = 3; // Pin dla każdej diody LED
const int secondLedPin = 5;
const int thirdLedPin  = 6;

void setup()
{
  pinMode(firstLedPin, OUTPUT);  // Ustawienie pinu diody LED jako wyjścia
  pinMode(secondLedPin, OUTPUT); // Ustawienie pinu diody LED jako wyjścia
  pinMode(thirdLedPin, OUTPUT);  // Ustawienie pinu diody LED jako wyjścia
}

void loop()
{
  // Zapalenie każdej diody LED na 1000 ms (1 s)
  blinkLED(firstLedPin,  1000);
  blinkLED(secondLedPin, 1000);
  blinkLED(thirdLedPin,  1000);
}


// Funkcja powodująca miganie diodą LED, podłączoną do podanego pinu i w podanych w milisekundach odstępach czasowych
void blinkLED(int pin, int duration)
{
  digitalWrite(pin, HIGH);     // Zapalenie diody LED
  delay(duration);
  digitalWrite(pin, LOW);      // Zgaszenie diody LED
  delay(duration);
}
