/* Szkic accel_9250
 * Odczytuje wartości z akcelerometru i wyświetla je w m/s2
 */

#include "MPU9250.h"

//  Adres I2C IMU. Jeśli poniższy adres nie zadziała, spróbuj 0x69
#define IMU_ADDRESS 0x68

MPU9250 IMU(Wire, IMU_ADDRESS); // Deklaracja obiektu IMU

void setup() {

  Serial.begin(9600);
  while(!Serial);

  // Inicjalizacja IMU
  int status = IMU.begin();
  if (status < 0) {
    Serial.println("Błąd inicjalizajci IMU");
    Serial.print("Błędna wartość: "); Serial.println(status);
    while(1); // Zatrzymanie szkicu
  }

}

void loop() {

  IMU.readSensor();

  // Odczyt przyspieszenia na każdej z osi
  float ax = IMU.getAccelX_mss();
  float ay = IMU.getAccelY_mss();
  float az = IMU.getAccelZ_mss();

  // Wyświetlenie przyspieszenia w stopniach na sekundę
  Serial.print("ax:");  Serial.print(ax, 4);
  Serial.print(",ay:"); Serial.print(ay, 4);
  Serial.print(",az:"); Serial.print(az, 4);
  Serial.println();
  delay(100);
}
